/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.persistence.orientdb;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.orientechnologies.orient.core.db.OPartitionedDatabasePool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.gcube.vremanagement.executor.SmartExecutorInitializator;
import org.gcube.vremanagement.executor.exception.SchedulePersistenceException;
import org.gcube.vremanagement.executor.json.ObjectMapperManager;
import org.gcube.vremanagement.executor.persistence.SmartExecutorPersistenceConfiguration;
import org.gcube.vremanagement.executor.persistence.SmartExecutorPersistenceConnector;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.gcube.vremanagement.executor.plugin.PluginStateEvolution;
import org.gcube.vremanagement.executor.scheduledtask.ScheduledTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrientDBPersistenceConnector
extends SmartExecutorPersistenceConnector {
    private static final Logger logger = LoggerFactory.getLogger(OrientDBPersistenceConnector.class);
    protected static final int LAST = -1;
    protected final String scope;
    protected final String SCOPE = "scope";
    protected final String UUID = "uuid";
    protected final String ITERATION = "iteration";
    protected final String TIMESTAMP = "timestamp";
    protected final String RUN_ON = "runOn";
    protected OPartitionedDatabasePool oPartitionedDatabasePool;
    protected ObjectMapper mapper;

    public OrientDBPersistenceConnector(String scope, SmartExecutorPersistenceConfiguration configuration) throws Exception {
        this.scope = scope;
        this.prepareConnection(configuration);
        this.mapper = ObjectMapperManager.getObjectMapper();
    }

    public OrientDBPersistenceConnector(SmartExecutorPersistenceConfiguration configuration) throws Exception {
        this(SmartExecutorInitializator.getCurrentScope(), configuration);
    }

    protected void prepareConnection(SmartExecutorPersistenceConfiguration configuration) throws Exception {
        logger.debug("Preparing Connection for {}", (Object)this.getClass().getSimpleName());
        String url = configuration.getURL();
        String username = configuration.getUsername();
        String password = configuration.getPassword();
        this.oPartitionedDatabasePool = new OPartitionedDatabasePool(url, username, password);
    }

    protected void prepareObjectMapper() {
        this.mapper = new ObjectMapper();
    }

    public void close() throws Exception {
        this.oPartitionedDatabasePool.close();
    }

    protected PluginStateEvolution getPluginStateEvolution(UUID uuid, int iterationNumber) throws Exception {
        try (ODatabaseDocumentTx db = null;){
            PluginStateEvolution pluginStateEvolution;
            db = this.oPartitionedDatabasePool.acquire();
            String type = PluginStateEvolution.class.getSimpleName();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("uuid", uuid.toString());
            params.put("scope", this.scope);
            OSQLSynchQuery query = null;
            if (iterationNumber != -1) {
                query = new OSQLSynchQuery(String.format("SELECT FROM %s WHERE %s = :%s AND %s = :%s AND %s = :%s ORDER BY %s DESC LIMIT 1", type, "scope", "scope", "uuid", "uuid", "iteration", "iteration", "timestamp"));
                params.put("iteration", iterationNumber);
            } else {
                query = new OSQLSynchQuery(String.format("SELECT FROM %s WHERE %s = :%s AND %s = :%s ORDER BY %s DESC", type, "scope", "scope", "uuid", "uuid", "iteration"));
            }
            List result = (List)query.execute(new Object[]{params});
            ODocument resDoc = null;
            if (iterationNumber != -1) {
                resDoc = (ODocument)result.get(0);
            } else {
                long maxTimestamp = 0L;
                for (ODocument oDoc : result) {
                    long tm = (Long)oDoc.field("timestamp");
                    if (maxTimestamp > tm) continue;
                    maxTimestamp = tm;
                    resDoc = oDoc;
                }
            }
            String json = resDoc.toJSON("class");
            PluginStateEvolution pluginStateEvolution2 = pluginStateEvolution = (PluginStateEvolution)this.mapper.readValue(json, PluginStateEvolution.class);
            return pluginStateEvolution2;
        }
    }

    public PluginStateEvolution getPluginInstanceState(UUID uuid, int iterationNumber) throws Exception {
        return this.getPluginStateEvolution(uuid, iterationNumber);
    }

    public PluginStateEvolution getLastPluginInstanceState(UUID uuid) throws Exception {
        return this.getPluginStateEvolution(uuid, -1);
    }

    public void pluginStateEvolution(PluginStateEvolution pluginStateEvolution, Exception exception) throws Exception {
        try (ODatabaseDocumentTx db = null;){
            db = this.oPartitionedDatabasePool.acquire();
            ODocument doc = new ODocument(PluginStateEvolution.class.getSimpleName());
            String json = this.mapper.writeValueAsString((Object)pluginStateEvolution);
            doc.fromJSON(json);
            doc.field("scope", (Object)this.scope);
            doc.save();
            db.commit();
        }
    }

    public void addScheduledTask(ScheduledTask scheduledTask) throws SchedulePersistenceException {
        try (ODatabaseDocumentTx db = null;){
            db = this.oPartitionedDatabasePool.acquire();
            ODocument doc = new ODocument(ScheduledTask.class.getSimpleName());
            long timestamp = Calendar.getInstance().getTimeInMillis();
            doc.field("timestamp", (Object)timestamp);
            String json = this.mapper.writeValueAsString((Object)scheduledTask);
            doc.fromJSON(json);
            doc.save();
            db.commit();
        }
    }

    public List<ScheduledTask> getOrphanScheduledTasks(Collection<? extends PluginDeclaration> pluginDeclarations) throws SchedulePersistenceException {
        try (ODatabaseDocumentTx db = null;){
            db = this.oPartitionedDatabasePool.acquire();
            String type = ScheduledTask.class.getSimpleName();
            String queryString = String.format("SELECT * FROM %s WHERE %s = '%s'", type, "scope", SmartExecutorInitializator.getCurrentScope());
            if (pluginDeclarations != null && pluginDeclarations.size() != 0) {
                boolean first = true;
                for (PluginDeclaration pluginDeclaration : pluginDeclarations) {
                    if (first) {
                        first = false;
                        queryString = String.format("%s AND ( (%s = '%s') ", queryString, "launchParameter.pluginName", pluginDeclaration.getName());
                        continue;
                    }
                    queryString = String.format("%s OR (%s = '%s') ", queryString, "launchParameter.pluginName", pluginDeclaration.getName());
                }
                queryString = queryString + ")";
            }
            OSQLSynchQuery query = new OSQLSynchQuery(queryString);
            List result = (List)query.execute(new Object[0]);
            ArrayList<ScheduledTask> arrayList = new ArrayList<ScheduledTask>();
            for (ODocument doc : result) {
                String json = doc.toJSON("class");
                ScheduledTask scheduledTask = (ScheduledTask)this.mapper.readValue(json, ScheduledTask.class);
                try {
                    arrayList.add(scheduledTask);
                }
                catch (Exception e) {
                    logger.error("An Exception occurred while evaluating if {} is orphan", (Object)json);
                }
            }
            ArrayList<ScheduledTask> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    protected ODocument getScheduledTaskDocument(ODatabaseDocumentTx db, UUID uuid) throws SchedulePersistenceException {
        try {
            String type = ScheduledTask.class.getSimpleName();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("uuid", uuid.toString());
            OSQLSynchQuery query = new OSQLSynchQuery(String.format("SELECT FROM %s WHERE %s = :%s", type, "uuid", "uuid"));
            List result = (List)query.execute(new Object[]{params});
            if (result.size() > 1) {
                String error = String.format("Found more than one %s with UUID=%s. %s. %s.", type, uuid.toString(), "This is really strange and should not occur", "Please contact the smart-executor administrator");
                logger.error(error);
                throw new SchedulePersistenceException(error);
            }
            if (result.size() == 0) {
                String error = String.format("No %s with UUID=%s found.", type, uuid.toString());
                logger.error(error);
                throw new SchedulePersistenceException(error);
            }
            return (ODocument)result.get(0);
        }
        catch (Exception e) {
            throw new SchedulePersistenceException((Throwable)e);
        }
    }

    public ScheduledTask getScheduledTask(UUID uuid) throws SchedulePersistenceException {
        try (ODatabaseDocumentTx db = null;){
            db = this.oPartitionedDatabasePool.acquire();
            ODocument doc = this.getScheduledTaskDocument(db, uuid);
            String json = doc.toJSON("class");
            ScheduledTask scheduledTask = (ScheduledTask)this.mapper.readValue(json, ScheduledTask.class);
            return scheduledTask;
        }
    }

    public void reserveScheduledTask(ScheduledTask scheduledTask) throws SchedulePersistenceException {
        this.releaseScheduledTask(scheduledTask);
    }

    public void removeScheduledTask(UUID uuid) throws SchedulePersistenceException {
        try (ODatabaseDocumentTx db = null;){
            db = this.oPartitionedDatabasePool.acquire();
            ODocument doc = this.getScheduledTaskDocument(db, uuid);
            doc.delete();
            db.commit();
        }
    }

    public void removeScheduledTask(ScheduledTask scheduledTask) throws SchedulePersistenceException {
        this.removeScheduledTask(scheduledTask.getUUID());
    }

    public void releaseScheduledTask(UUID uuid) throws SchedulePersistenceException {
        try (ODatabaseDocumentTx db = null;){
            db = this.oPartitionedDatabasePool.acquire();
            ODocument doc = this.getScheduledTaskDocument(db, uuid);
            doc.removeField("runOn");
            doc.save();
        }
    }

    public void releaseScheduledTask(ScheduledTask scheduledTask) throws SchedulePersistenceException {
        this.releaseScheduledTask(scheduledTask.getUUID());
    }
}

