/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.persistence;

import java.util.HashMap;
import java.util.UUID;
import org.gcube.common.clients.exceptions.DiscoveryException;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.smartgears.ContextProvider;
import org.gcube.vremanagement.executor.client.plugins.ExecutorPlugin;
import org.gcube.vremanagement.executor.client.plugins.query.filter.EndpointDiscoveryFilter;
import org.gcube.vremanagement.executor.client.plugins.query.filter.SpecificEndpointDiscoveryFilter;
import org.gcube.vremanagement.executor.client.proxies.SmartExecutorProxy;
import org.gcube.vremanagement.executor.exception.ExecutorException;
import org.gcube.vremanagement.executor.json.ObjectMapperManager;
import org.gcube.vremanagement.executor.plugin.PluginStateEvolution;
import org.gcube.vremanagement.executor.plugin.PluginStateNotification;
import org.gcube.vremanagement.executor.plugin.RunOn;
import org.gcube.vremanagement.executor.scheduledtask.ScheduledTask;
import org.gcube.vremanagement.executor.scheduledtask.ScheduledTaskPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SmartExecutorPersistenceConnector
extends PluginStateNotification
implements ScheduledTaskPersistence {
    private static final Logger logger = LoggerFactory.getLogger(SmartExecutorPersistenceConnector.class);

    public SmartExecutorPersistenceConnector() {
        super(new HashMap());
    }

    public abstract void close() throws Exception;

    public abstract PluginStateEvolution getPluginInstanceState(UUID var1, int var2) throws Exception;

    public abstract PluginStateEvolution getLastPluginInstanceState(UUID var1) throws Exception;

    protected boolean isOrphan(ScheduledTask scheduledTask) throws Exception {
        try {
            UUID uuid = scheduledTask.getUUID();
            RunOn runOn = scheduledTask.getRunOn();
            if (runOn == null) {
                return true;
            }
            try {
                HostingNode hostingNode = (HostingNode)ContextProvider.get().container().profile(HostingNode.class);
                String hnAddress = hostingNode.profile().description().name();
                if (runOn.getHostingNode().getAddress().compareTo(hnAddress) == 0) {
                    return true;
                }
            }
            catch (Exception e) {
                logger.error("Unable to check if current hosting node is the same of the one in ScheduledTask", (Throwable)e);
            }
            String address = runOn.getEService().getAddress();
            SpecificEndpointDiscoveryFilter specificEndpointDiscoveryFilter = new SpecificEndpointDiscoveryFilter(address);
            String pluginName = scheduledTask.getLaunchParameter().getPluginName();
            try {
                SmartExecutorProxy proxy = (SmartExecutorProxy)ExecutorPlugin.getExecutorProxy((String)pluginName, null, null, (EndpointDiscoveryFilter)specificEndpointDiscoveryFilter).build();
                proxy.getStateEvolution(uuid.toString());
                logger.trace("{} is not orphan.", (Object)ObjectMapperManager.getObjectMapper().writeValueAsString((Object)scheduledTask));
                return false;
            }
            catch (DiscoveryException | ExecutorException e) {
                logger.trace("{} is considered orphan.", (Object)ObjectMapperManager.getObjectMapper().writeValueAsString((Object)scheduledTask), (Object)e);
                return true;
            }
            catch (Throwable e) {
                logger.trace("{} is NOT considered orphan.", (Object)ObjectMapperManager.getObjectMapper().writeValueAsString((Object)scheduledTask), (Object)e);
                return false;
            }
        }
        catch (Exception e) {
            String string = ObjectMapperManager.getObjectMapper().writeValueAsString((Object)scheduledTask);
            logger.error("Error while checking orphanity of " + string + ". Considering as not orphan.", (Throwable)e);
            return false;
        }
    }
}

