/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.gcube.vremanagement.executor.api.types.LaunchParameter;
import org.gcube.vremanagement.executor.exception.ExecutorException;
import org.gcube.vremanagement.executor.exception.InputsNullException;
import org.gcube.vremanagement.executor.exception.InvalidInputsException;
import org.gcube.vremanagement.executor.exception.SchedulePersistenceException;
import org.gcube.vremanagement.executor.exception.SchedulerNotFoundException;
import org.gcube.vremanagement.executor.json.SEMapper;
import org.gcube.vremanagement.executor.persistence.SmartExecutorPersistenceConnector;
import org.gcube.vremanagement.executor.persistence.SmartExecutorPersistenceFactory;
import org.gcube.vremanagement.executor.plugin.PluginStateEvolution;
import org.gcube.vremanagement.executor.scheduler.SmartExecutorScheduler;
import org.gcube.vremanagement.executor.scheduler.SmartExecutorSchedulerFactory;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="plugins")
public class RestSmartExecutor {
    private static Logger logger = LoggerFactory.getLogger(RestSmartExecutor.class);
    private static final String UUID_PATH_PARAM = "uuid";
    private static final String PLUGIN_NAME_PATH_PARAM = "pluginName";

    @POST
    @Path(value="/{pluginName}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"text/plain"})
    public String launch(@PathParam(value="pluginName") String pluginName, String launchParameterString) throws ExecutorException {
        try {
            logger.info("Requested to launch {} ({})", (Object)pluginName, (Object)launchParameterString);
            LaunchParameter launchParameter = (LaunchParameter)SEMapper.unmarshal(LaunchParameter.class, (String)launchParameterString);
            if (pluginName == null) {
                String error = String.format("Plugin Name provided in the URL (%s) cannot be null", pluginName);
                logger.error(error);
                throw new InputsNullException(error);
            }
            if (pluginName.compareTo(launchParameter.getPluginName()) != 0) {
                String error = String.format("Plugin Name provided in the URL (%s) does not match with the one provided in %s (%s)", pluginName, LaunchParameter.class.getSimpleName(), launchParameter.getPluginName());
                logger.error(error);
                throw new InvalidInputsException(error);
            }
            SmartExecutorScheduler smartExecutorScheduler = SmartExecutorSchedulerFactory.getSmartExecutorScheduler();
            UUID uuid = smartExecutorScheduler.schedule(launchParameter, null);
            logger.info("{} ({}) has been lauched with uuid {}", new Object[]{pluginName, launchParameterString, uuid});
            return uuid.toString();
        }
        catch (ExecutorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecutorException((Throwable)e);
        }
    }

    @GET
    @Path(value="/{pluginName}/{uuid}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String getPluginStateEvolution(@PathParam(value="pluginName") String pluginName, @PathParam(value="uuid") String executionIdentifier, @QueryParam(value="iterationNumber") Integer iterationNumber) throws ExecutorException {
        PluginStateEvolution pluginStateEvolution = null;
        try {
            SmartExecutorPersistenceConnector persistenceConnector = SmartExecutorPersistenceFactory.getPersistenceConnector();
            pluginStateEvolution = persistenceConnector.getPluginInstanceState(UUID.fromString(executionIdentifier), iterationNumber);
            logger.info("{} for {} (iteration n. {}) is {}", new Object[]{PluginStateEvolution.class.getSimpleName(), executionIdentifier, iterationNumber, pluginStateEvolution});
        }
        catch (ExecutorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecutorException((Throwable)e);
        }
        if (pluginName.compareTo(pluginStateEvolution.getPluginDeclaration().getName()) != 0) {
            String error = String.format("Plugin Name provided in the URL (%s) does not match with the one got from %s (%s)", pluginName, PluginStateEvolution.class.getSimpleName(), pluginStateEvolution.getPluginDeclaration().getName());
            throw new InvalidInputsException(error);
        }
        try {
            return SEMapper.marshal((Object)pluginStateEvolution);
        }
        catch (JsonProcessingException e) {
            throw new ExecutorException((Throwable)e);
        }
    }

    @DELETE
    @Path(value="/{pluginName}/{uuid}")
    public boolean delete(@PathParam(value="pluginName") String pluginName, @PathParam(value="uuid") String executionIdentifier, @QueryParam(value="globally") Boolean globally) throws ExecutorException {
        try {
            if (globally == null) {
                globally = false;
            }
            logger.info("Requested to delete for {} with UUID {} {}", new Object[]{pluginName, executionIdentifier, globally != false ? "globally" : ""});
            boolean currentStopped = true;
            try {
                SmartExecutorScheduler smartExecutorScheduler = SmartExecutorSchedulerFactory.getSmartExecutorScheduler();
                UUID uuid = UUID.fromString(executionIdentifier);
                smartExecutorScheduler.stop(uuid, globally.booleanValue());
            }
            catch (SchedulerNotFoundException e) {
                logger.error("Error unscheduling task {}", (Object)executionIdentifier, (Object)e);
                throw new ExecutorException((Throwable)e);
            }
            catch (SchedulerException e) {
                logger.error("Error unscheduling task {}", (Object)executionIdentifier, (Object)e);
                throw new ExecutorException((Throwable)e);
            }
            catch (SchedulePersistenceException e) {
                logger.error("Error removing scheduled task from persistence.", (Throwable)e);
            }
            catch (ExecutorException e) {
                throw e;
            }
            catch (Exception e) {
                logger.error("Error unscheduling task {}", (Object)executionIdentifier, (Object)e);
                throw new ExecutorException((Throwable)e);
            }
            logger.info("{} with UUID {} was{} stopped successfully", new Object[]{pluginName, executionIdentifier, currentStopped ? "" : " NOT"});
            return currentStopped;
        }
        catch (ExecutorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecutorException((Throwable)e);
        }
    }

    @GET
    @Path(value="scheduled")
    @Produces(value={"application/json;charset=UTF-8"})
    public String all(@QueryParam(value="globally") Boolean globally) throws ExecutorException {
        return "[]";
    }
}

