/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.persistence.orientdb;

import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.gcube.vremanagement.executor.SmartExecutorInitializator;
import org.gcube.vremanagement.executor.exception.ExecutorException;
import org.gcube.vremanagement.executor.exception.PluginInstanceNotFoundException;
import org.gcube.vremanagement.executor.exception.SchedulePersistenceException;
import org.gcube.vremanagement.executor.json.ExtendedSEMapper;
import org.gcube.vremanagement.executor.persistence.SmartExecutorPersistenceConfiguration;
import org.gcube.vremanagement.executor.persistence.SmartExecutorPersistenceConnector;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.gcube.vremanagement.executor.plugin.PluginStateEvolution;
import org.gcube.vremanagement.executor.scheduledtask.ScheduledTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrientDBPersistenceConnector
extends SmartExecutorPersistenceConnector {
    private static final Logger logger = LoggerFactory.getLogger(OrientDBPersistenceConnector.class);
    protected final String SCOPE = "scope";
    protected final String UUID = "uuid";
    protected final String ITERATION = "iteration";
    protected final String TIMESTAMP = "timestamp";
    protected final String RUN_ON = "runOn";
    protected ODatabasePool oDatabasePool;

    public OrientDBPersistenceConnector(SmartExecutorPersistenceConfiguration configuration) throws Exception {
        this.prepareConnection(configuration);
    }

    protected void prepareConnection(SmartExecutorPersistenceConfiguration configuration) throws Exception {
        logger.debug("Preparing Connection for {}", (Object)this.getClass().getSimpleName());
        String url = configuration.getURL();
        String username = configuration.getUsername();
        String password = configuration.getPassword();
        this.oDatabasePool = new ODatabasePool(url, username, password);
    }

    public void close() throws Exception {
        this.oDatabasePool.close();
    }

    public PluginStateEvolution getPluginInstanceState(UUID uuid, Integer iterationNumber) throws PluginInstanceNotFoundException, ExecutorException {
        try (ODatabaseSession oDatabaseSession = null;){
            PluginStateEvolution pluginStateEvolution;
            oDatabaseSession = this.oDatabasePool.acquire();
            String type = PluginStateEvolution.class.getSimpleName();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("uuid", uuid.toString());
            params.put("scope", SmartExecutorInitializator.getCurrentScope());
            OSQLSynchQuery query = null;
            if (iterationNumber != null && iterationNumber > 0) {
                query = new OSQLSynchQuery(String.format("SELECT FROM %s WHERE %s = :%s AND %s = :%s AND %s = :%s ORDER BY %s DESC LIMIT 1", type, "scope", "scope", "uuid", "uuid", "iteration", "iteration", "timestamp"));
                params.put("iteration", iterationNumber);
            } else {
                query = new OSQLSynchQuery(String.format("SELECT FROM %s WHERE %s = :%s AND %s = :%s ORDER BY %s DESC, %s DESC LIMIT 1", type, "scope", "scope", "uuid", "uuid", "iteration", "timestamp"));
            }
            List result = (List)query.execute(new Object[]{params});
            ODocument resDoc = (ODocument)result.get(0);
            String json = resDoc.toJSON("class");
            PluginStateEvolution pluginStateEvolution2 = pluginStateEvolution = (PluginStateEvolution)ExtendedSEMapper.getInstance().unmarshal(PluginStateEvolution.class, json);
            return pluginStateEvolution2;
        }
    }

    public void pluginStateEvolution(PluginStateEvolution pluginStateEvolution, Exception exception) throws Exception {
        try (ODatabaseSession oDatabaseSession = null;){
            oDatabaseSession = this.oDatabasePool.acquire();
            ODocument doc = new ODocument(PluginStateEvolution.class.getSimpleName());
            String json = ExtendedSEMapper.getInstance().marshal((Object)pluginStateEvolution);
            doc.fromJSON(json);
            doc.field("scope", (Object)SmartExecutorInitializator.getCurrentScope());
            doc.save();
            oDatabaseSession.commit();
        }
    }

    public void addScheduledTask(ScheduledTask scheduledTask) throws SchedulePersistenceException {
        try (ODatabaseSession oDatabaseSession = null;){
            oDatabaseSession = this.oDatabasePool.acquire();
            ODocument doc = new ODocument(ScheduledTask.class.getSimpleName());
            long timestamp = Calendar.getInstance().getTimeInMillis();
            doc.field("timestamp", (Object)timestamp);
            String json = ExtendedSEMapper.getInstance().marshal((Object)scheduledTask);
            doc.fromJSON(json);
            doc.save();
            oDatabaseSession.commit();
        }
    }

    public List<ScheduledTask> getOrphanScheduledTasks(Collection<? extends PluginDeclaration> pluginDeclarations) throws SchedulePersistenceException {
        try (ODatabaseSession oDatabaseSession = null;){
            oDatabaseSession = this.oDatabasePool.acquire();
            String type = ScheduledTask.class.getSimpleName();
            String queryString = String.format("SELECT * FROM %s WHERE %s = '%s'", type, "scope", SmartExecutorInitializator.getCurrentScope());
            if (pluginDeclarations != null && pluginDeclarations.size() != 0) {
                boolean first = true;
                for (PluginDeclaration pluginDeclaration : pluginDeclarations) {
                    if (first) {
                        first = false;
                        queryString = String.format("%s AND ( (%s = '%s') ", queryString, "launchParameter.pluginName", pluginDeclaration.getName());
                        continue;
                    }
                    queryString = String.format("%s OR (%s = '%s') ", queryString, "launchParameter.pluginName", pluginDeclaration.getName());
                }
                queryString = queryString + ")";
            }
            OSQLSynchQuery query = new OSQLSynchQuery(queryString);
            List result = (List)query.execute(new Object[0]);
            ArrayList<ScheduledTask> arrayList = new ArrayList<ScheduledTask>();
            for (ODocument doc : result) {
                String json = doc.toJSON("class");
                ScheduledTask scheduledTask = (ScheduledTask)ExtendedSEMapper.getInstance().unmarshal(ScheduledTask.class, json);
                try {
                    if (!this.isOrphan(scheduledTask)) continue;
                    arrayList.add(scheduledTask);
                }
                catch (Exception e) {
                    logger.error("An Exception occurred while evaluating if {} is orphan", (Object)json, (Object)e);
                }
            }
            ArrayList<ScheduledTask> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    protected ODocument getScheduledTaskDocument(UUID uuid) throws SchedulePersistenceException {
        try {
            String type = ScheduledTask.class.getSimpleName();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("uuid", uuid.toString());
            OSQLSynchQuery query = new OSQLSynchQuery(String.format("SELECT FROM %s WHERE %s = :%s", type, "uuid", "uuid"));
            List result = (List)query.execute(new Object[]{params});
            if (result.size() > 1) {
                String error = String.format("Found more than one %s with UUID=%s. %s. %s.", type, uuid.toString(), "This is really strange and should not occur", "Please contact the smart-executor administrator");
                logger.error(error);
                throw new SchedulePersistenceException(error);
            }
            if (result.size() == 0) {
                String error = String.format("No %s with UUID=%s found.", type, uuid.toString());
                logger.error(error);
                throw new SchedulePersistenceException(error);
            }
            return (ODocument)result.get(0);
        }
        catch (Exception e) {
            throw new SchedulePersistenceException((Throwable)e);
        }
    }

    public ScheduledTask getScheduledTask(UUID uuid) throws SchedulePersistenceException {
        try (ODatabaseSession oDatabaseSession = null;){
            oDatabaseSession = this.oDatabasePool.acquire();
            ODocument doc = this.getScheduledTaskDocument(uuid);
            String json = doc.toJSON("class");
            ScheduledTask scheduledTask = (ScheduledTask)ExtendedSEMapper.getInstance().unmarshal(ScheduledTask.class, json);
            return scheduledTask;
        }
    }

    public void reserveScheduledTask(ScheduledTask scheduledTask) throws SchedulePersistenceException {
        this.releaseScheduledTask(scheduledTask);
    }

    public void removeScheduledTask(UUID uuid) throws SchedulePersistenceException {
        try (ODatabaseSession oDatabaseSession = null;){
            oDatabaseSession = this.oDatabasePool.acquire();
            ODocument doc = this.getScheduledTaskDocument(uuid);
            doc.delete();
            oDatabaseSession.commit();
        }
    }

    public void removeScheduledTask(ScheduledTask scheduledTask) throws SchedulePersistenceException {
        this.removeScheduledTask(scheduledTask.getUUID());
    }

    public void releaseScheduledTask(UUID uuid) throws SchedulePersistenceException {
        try (ODatabaseSession oDatabaseSession = null;){
            oDatabaseSession = this.oDatabasePool.acquire();
            ODocument doc = this.getScheduledTaskDocument(uuid);
            doc.removeField("runOn");
            doc.save();
        }
    }

    public void releaseScheduledTask(ScheduledTask scheduledTask) throws SchedulePersistenceException {
        this.releaseScheduledTask(scheduledTask.getUUID());
    }
}

