/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.workspace.client.details;

import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.form.FieldSet;
import com.gwtext.client.widgets.form.FormPanel;
import com.gwtext.client.widgets.form.TextArea;
import com.gwtext.client.widgets.form.TextField;
import com.gwtext.client.widgets.form.Validator;
import com.gwtext.client.widgets.form.event.TextFieldListener;
import com.gwtext.client.widgets.layout.AnchorLayoutData;
import com.gwtext.client.widgets.layout.ContainerLayout;
import com.gwtext.client.widgets.layout.FormLayout;
import com.gwtext.client.widgets.layout.HorizontalLayout;
import com.gwtext.client.widgets.layout.LayoutData;
import java.util.Date;
import org.gcube.portlets.user.workspace.client.Util;
import org.gcube.portlets.user.workspace.client.tree.events.NodeNameValidator;
import org.gcube.portlets.user.workspace.client.util.GWTUtil;
import org.gcube.portlets.user.workspace.client.workspace.GWTWorkspace;
import org.gcube.portlets.user.workspace.client.workspace.GWTWorkspaceItem;
import org.gcube.portlets.user.workspace.client.workspace.GWTWorkspaceItemType;
import org.gcube.portlets.user.workspace.client.workspace.folder.GWTFolderItem;

public class ItemDetailPanel
extends FormPanel {
    protected GWTWorkspace workspace;
    protected GWTWorkspaceItem showedItem;
    protected TextField name;
    protected TextArea description;
    protected TextField owner;
    protected TextField creationTime;
    protected TextField dimension;
    protected NodeNameValidator validator;

    public ItemDetailPanel(GWTWorkspace workspace) {
        this.workspace = workspace;
        int panelHeight = 120;
        this.setFrame(false);
        this.setWidth(440);
        this.setHeight(120);
        this.setBorder(false);
        this.setPaddings(2, 2, 0, 2);
        this.setLabelWidth(58);
        FieldSet itemSet = new FieldSet();
        itemSet.setTitle("Item details");
        Panel contentPanel = new Panel();
        contentPanel.setLayout((ContainerLayout)new HorizontalLayout(5));
        contentPanel.setBorder(false);
        int columnHeight = 98;
        Panel column1 = new Panel();
        column1.setWidth(230);
        column1.setLayout((ContainerLayout)new FormLayout());
        column1.setHeight(98);
        column1.setBorder(false);
        this.validator = new NodeNameValidator();
        this.name = new TextField("Name", "name", 230, "name");
        this.name.setSelectOnFocus(true);
        this.name.setRegex("^[^//]*$");
        this.name.setRegexText("The name can't contain / character.");
        this.name.setValidator((Validator)this.validator);
        this.name.setAllowBlank(false);
        this.name.setBlankText("The name can't be void.");
        this.name.setFieldMsgTarget("qtip");
        this.name.addListener((TextFieldListener)new /* Unavailable Anonymous Inner Class!! */);
        column1.add((Component)this.name, (LayoutData)new AnchorLayoutData("99%"));
        this.description = new TextArea("Description", "description");
        this.description.setId("ItemDetailPanel-description");
        this.description.setWidth(200);
        this.description.setHeight(75);
        this.description.setValue("n/a");
        this.description.addListener((TextFieldListener)new /* Unavailable Anonymous Inner Class!! */);
        column1.add((Component)this.description, (LayoutData)new AnchorLayoutData("99%"));
        Panel column2 = new Panel();
        column2.setLayout((ContainerLayout)new FormLayout());
        column2.setBorder(false);
        column2.setHeight(98);
        column2.setWidth(190);
        this.owner = new TextField("Owner", "owner", 100, "owner");
        this.owner.setValue("n/a");
        GWTUtil.setFieldUnEditable((TextField)this.owner);
        column2.add((Component)this.owner, (LayoutData)new AnchorLayoutData("99%"));
        this.creationTime = new TextField("Creation Time", "creationTime", 100, "creationTime");
        this.creationTime.setValue("n/a");
        GWTUtil.setFieldUnEditable((TextField)this.creationTime);
        column2.add((Component)this.creationTime, (LayoutData)new AnchorLayoutData("99%"));
        this.dimension = new TextField("Dimension", "dimension", 100, "dimension");
        this.dimension.setValue("n/a");
        GWTUtil.setFieldUnEditable((TextField)this.dimension);
        column2.add((Component)this.dimension, (LayoutData)new AnchorLayoutData("99%"));
        contentPanel.add((Component)column1);
        contentPanel.add((Component)column2);
        itemSet.add((Component)contentPanel, (LayoutData)new AnchorLayoutData("99%"));
        this.add((Component)itemSet, (LayoutData)new AnchorLayoutData("100%"));
    }

    public void setData(GWTWorkspaceItem item) {
        this.showedItem = item;
        this.validator.setRenameItem(item);
        this.name.setValue(item.getName());
        this.description.setValue(item.getDescription());
        this.owner.setValue(item.getOwner());
        this.owner.setTitle(item.getOwner());
        this.creationTime.setValue(Util.dateFormat((Date)item.getCreationTime()));
        this.creationTime.setTitle(Util.dateFormat((Date)item.getCreationTime()));
        if (item.getType() == GWTWorkspaceItemType.FOLDER) {
            this.dimension.setValue(String.valueOf(item.countSubTreeChildren()));
            this.dimension.setTitle(String.valueOf(item.countSubTreeChildren()));
        } else {
            GWTFolderItem folderItem = (GWTFolderItem)item;
            this.dimension.setValue(Util.toAutoMetric((long)folderItem.getLength()));
            this.dimension.setTitle(Util.toAutoMetric((long)folderItem.getLength()));
        }
        if (this.showedItem.isRoot()) {
            GWTUtil.setFieldUnEditable((TextField)this.name);
            GWTUtil.setFieldUnEditable((TextField)this.description);
        } else {
            GWTUtil.setFieldEditable((TextField)this.name);
            GWTUtil.setFieldEditable((TextField)this.description);
        }
    }

    protected void changeName(String newName) {
        if (!this.showedItem.getName().equals(newName)) {
            this.workspace.renameItem(this.showedItem, newName);
        }
    }

    protected void changeDescription(String newDescription) {
        if (!this.showedItem.getDescription().equals(newDescription)) {
            this.workspace.setItemDescription(this.showedItem, newDescription);
        }
    }
}

