/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.workspace.server.webdav;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserServiceUtil;
import com.liferay.portal.sharepoint.SharepointUtil;
import com.liferay.portal.webdav.BaseResourceImpl;
import com.liferay.portal.webdav.BaseWebDAVStorageImpl;
import com.liferay.portal.webdav.Resource;
import com.liferay.portal.webdav.WebDAVException;
import com.liferay.portal.webdav.WebDAVRequest;
import com.liferay.portal.webdav.WebDAVUtil;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.gcube.portlets.user.homelibrary.home.Home;
import org.gcube.portlets.user.homelibrary.home.HomeLibrary;
import org.gcube.portlets.user.homelibrary.home.HomeManager;
import org.gcube.portlets.user.homelibrary.home.HomeManagerFactory;
import org.gcube.portlets.user.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.exceptions.UserNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.portlets.user.workspace.server.webdav.FolderItemResource;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayUserManager;

public class HomeLibraryWebDav
extends BaseWebDAVStorageImpl {
    protected static Log logger = LogFactoryUtil.getLog(HomeLibraryWebDav.class);
    protected UserManager userManager = new LiferayUserManager();
    protected GroupManager groupManager = new LiferayGroupManager();

    public HomeLibraryWebDav() {
        logger.info((Object)"HomeLibraryWebDav initialized");
    }

    public Resource getResource(WebDAVRequest webDavRequest) throws WebDAVException {
        String loggedUser;
        logger.info((Object)"getResource");
        logger.trace((Object)("path: " + webDavRequest.getPath() + " userId: " + webDavRequest.getUserId()));
        String pathUser = this.getPathUser(webDavRequest);
        logger.trace((Object)("pathUser: " + pathUser));
        try {
            loggedUser = this.getUserScreenName(webDavRequest);
            logger.trace((Object)("loggedUser: " + loggedUser));
        }
        catch (Exception e) {
            logger.error((Object)"Error getting the logged user screenName", (Throwable)e);
            throw new WebDAVException("Error getting the logged user screenName", (Throwable)e);
        }
        if (!pathUser.equals(loggedUser)) {
            logger.error((Object)("Logged user " + loggedUser + " different from pathUser " + pathUser));
            throw new WebDAVException("Logged user " + loggedUser + " different from pathUser " + pathUser);
        }
        String scope = this.getScope(webDavRequest);
        logger.trace((Object)("scope: " + scope));
        if (scope == null) {
            String path = String.valueOf(this.getRootPath()) + webDavRequest.getPath();
            return new BaseResourceImpl(path, "", this.getToken());
        }
        return null;
    }

    public List<Resource> getResources(WebDAVRequest webDavRequest) throws WebDAVException {
        String loggedUser;
        logger.info((Object)"getResources");
        logger.trace((Object)("path: " + webDavRequest.getPath() + " userId: " + webDavRequest.getUserId()));
        String pathUser = this.getPathUser(webDavRequest);
        logger.trace((Object)("pathUser: " + pathUser));
        try {
            loggedUser = this.getUserScreenName(webDavRequest);
            logger.trace((Object)("loggedUser: " + loggedUser));
        }
        catch (Exception e) {
            logger.error((Object)"Error getting the logged user screenName", (Throwable)e);
            throw new WebDAVException("Error getting the logged user screenName", (Throwable)e);
        }
        if (!pathUser.equals(loggedUser)) {
            logger.error((Object)("Logged user " + loggedUser + " different from pathUser " + pathUser));
            throw new WebDAVException("Logged user " + loggedUser + " different from pathUser " + pathUser);
        }
        String scope = this.getScope(webDavRequest);
        logger.trace((Object)("scope: " + scope));
        if (scope == null) {
            try {
                return this.listUserScopes(webDavRequest, loggedUser);
            }
            catch (InternalErrorException e) {
                logger.error((Object)"Error listing the user scopes", (Throwable)e);
                throw new WebDAVException("Error listing the user scopes", (Throwable)e);
            }
        }
        return null;
    }

    protected List<Resource> listUserScopes(WebDAVRequest webDavRequest, String username) throws InternalErrorException {
        HomeManagerFactory factory = HomeLibrary.getHomeManagerFactory();
        List scopes = factory.listUserScopes(username);
        LinkedList<Resource> resources = new LinkedList<Resource>();
        for (String scope : scopes) {
            String webScope = scope.replace('/', '_');
            resources.add(this.toResource(webDavRequest, webScope));
        }
        return resources;
    }

    protected Resource toResource(WebDAVRequest webDavRequest, FolderItem item, boolean appendPath) throws InternalErrorException {
        String parentPath = String.valueOf(this.getRootPath()) + webDavRequest.getPath();
        String name = "";
        if (appendPath) {
            name = item.getName();
        }
        return new FolderItemResource(webDavRequest, item, parentPath, name);
    }

    protected Resource toResource(WebDAVRequest webDavRequest, WorkspaceFolder folder, boolean appendPath) throws InternalErrorException {
        String parentPath = String.valueOf(this.getRootPath()) + webDavRequest.getPath();
        String name = "";
        if (appendPath) {
            name = folder.getName();
        }
        BaseResourceImpl resource = new BaseResourceImpl(parentPath, name, folder.getName(), folder.getCreationTime().getTime(), folder.getLastModificationTime().getTime());
        resource.setModel((Object)folder);
        resource.setClassName(WorkspaceFolder.class.getName());
        return resource;
    }

    protected Resource toResource(WebDAVRequest webDavRequest, String scope) throws InternalErrorException {
        String parentPath = String.valueOf(this.getRootPath()) + webDavRequest.getPath();
        String name = scope;
        Date date = new Date();
        BaseResourceImpl resource = new BaseResourceImpl(parentPath, name, scope, date, date);
        resource.setModel((Object)scope);
        resource.setClassName(WorkspaceFolder.class.getName());
        return resource;
    }

    protected String getPathUser(WebDAVRequest webDavRequest) {
        String[] pathArray = webDavRequest.getPathArray();
        if (pathArray.length > 1) {
            return pathArray[1];
        }
        return "";
    }

    protected String getUserScreenName(WebDAVRequest webDavRequest) throws PortalException, SystemException {
        long userId = webDavRequest.getUserId();
        User user = UserServiceUtil.getUserById((long)userId);
        return user.getScreenName();
    }

    protected String getScope(WebDAVRequest webDavRequest) {
        String[] pathArray = webDavRequest.getPathArray();
        if (pathArray.length > 3) {
            return pathArray[3];
        }
        return null;
    }

    protected String getFolderPath(String path) {
        String[] pathArray = WebDAVUtil.getPathArray((String)path);
        if (pathArray.length > 2) {
            path = this.removeFoldersFromPath(path, 2);
        }
        return path;
    }

    protected String removeFoldersFromPath(String path, int index) {
        int i = 0;
        while (i < index) {
            int pos = path.indexOf("/");
            path = path.substring(pos + 1);
            ++i;
        }
        return path;
    }

    public String getGroupId(String path) {
        int pos;
        String[] pathArray = WebDAVUtil.getPathArray((String)path);
        String groupFolderName = pathArray[0];
        if (groupFolderName != null && (pos = groupFolderName.lastIndexOf("[")) != -1) {
            return groupFolderName.substring(pos, groupFolderName.length() - 1);
        }
        return null;
    }

    protected Workspace getUserWorkspace(String scope, WebDAVRequest webDavRequest) throws InternalErrorException, HomeNotFoundException, UserNotFoundException, PortalException, SystemException, WorkspaceFolderNotFoundException {
        logger.trace((Object)("getUserWorkspace scope: " + scope));
        long userId = webDavRequest.getUserId();
        logger.trace((Object)("UserId: " + userId));
        User user = UserServiceUtil.getUserById((long)userId);
        logger.trace((Object)("user.screename: " + user.getScreenName()));
        HomeManager homeManager = HomeLibrary.getHomeManagerFactory().getHomeManager(scope);
        Home home = homeManager.getHome(user.getScreenName());
        return home.getWorkspace();
    }

    public WorkspaceItem find(Workspace area, String path) throws InternalErrorException {
        String rootName;
        logger.info((Object)("find path: " + path));
        String[] pathArray = SharepointUtil.getPathArray((String)path);
        if (pathArray.length > 0 && pathArray[0].equals(rootName = area.getRoot().getName())) {
            path = this.removeFoldersFromPath(path, 1);
        }
        logger.trace((Object)("path without root: " + path));
        return this.internalFindPath(area, area.getRoot().getId(), path);
    }

    protected WorkspaceItem internalFindPath(Workspace area, String parentId, String path) throws InternalErrorException {
        block5: {
            logger.trace((Object)("internalFindPath parentId: " + parentId + " path: " + path));
            try {
                String[] pathArray = SharepointUtil.getPathArray((String)path);
                logger.trace((Object)("pathArray.length: " + pathArray.length));
                if (pathArray.length <= 0) break block5;
                String itemName = pathArray[0];
                if (area.exists(itemName, parentId)) {
                    WorkspaceItem item = area.find(itemName, parentId);
                    String childPath = this.removeFoldersFromPath(path, 1);
                    return this.internalFindPath(area, item.getId(), childPath);
                }
                return null;
            }
            catch (Exception e) {
                logger.error((Object)("Error analizyng path " + path), (Throwable)e);
                throw new InternalErrorException("Error analizyng path " + path, (Throwable)e);
            }
        }
        if (area.exists(path, parentId)) {
            return area.find(path, parentId);
        }
        return null;
    }
}

