/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch.admin;

import gr.forth.ics.isl.xsearch.resources.Resources;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class LoadConfiguration
extends HttpServlet {
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String loggedin;
        response.setContentType("text/html;charset=UTF-8");
        HttpSession session = request.getSession();
        String ses = request.getParameter("ses");
        if (ses == null) {
            ses = "";
        }
        if (!ses.equals("y") && (loggedin = (String)session.getAttribute("loggedin")) == null) {
            loggedin = "no";
            session.setAttribute("loggedin", (Object)loggedin);
            RequestDispatcher dispatcher = request.getRequestDispatcher("login.jsp");
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        PrintWriter out = response.getWriter();
        out.print("");
        InputStream in = null;
        try {
            String[] acceptedCategoriesArray;
            String id = request.getParameter("id");
            if (id == null) {
                id = "";
            }
            String propertiesFile = Resources.CONFIGURATIONS_FOLDER;
            if (!Resources.CONFIGURATIONS_FOLDER.endsWith("/") && !Resources.CONFIGURATIONS_FOLDER.endsWith("\\")) {
                propertiesFile = propertiesFile + "/";
            }
            propertiesFile = propertiesFile + "conf" + id + ".properties";
            Properties prop = new Properties();
            in = new FileInputStream(propertiesFile);
            prop.load(in);
            String descriptionDocument = prop.getProperty("gr.forth.ics.isl.xsearch.resources.opensearch.descriptionDocument");
            if (descriptionDocument != null) {
                if (ses.equals("y")) {
                    session.setAttribute("descrDoc", (Object)descriptionDocument.trim());
                } else {
                    Resources.DESCRIPTIONDOCUMENT = descriptionDocument.trim();
                }
            }
            String clusteringAlgorithmString = prop.getProperty("gr.forth.ics.isl.xsearch.resources.clustering.clusteringAlgorithm");
            try {
                int clusteringAlgorithm = Integer.parseInt(clusteringAlgorithmString.trim());
                if (clusteringAlgorithm < 1 || clusteringAlgorithm > 5) {
                    System.out.println("*** NOT APPROPRIATE CLUSTERING ALGORITHM! THE CLUSTERING ALGORITH WAS NOT LOADED!");
                } else if (ses.equals("y")) {
                    session.setAttribute("clustAlg", (Object)("" + clusteringAlgorithm));
                } else {
                    Resources.CLUSTERING_ALGORITHM = clusteringAlgorithm;
                }
            }
            catch (Exception e) {
                System.out.println("*** ERROR READING CLUSTERING ALGORITHM! THE CLUSTERING ALGORITH WAS NOT LOADED! ");
            }
            String mineQueryString = prop.getProperty("gr.forth.ics.isl.xsearch.resources.mining.mineQuery");
            try {
                if (mineQueryString.trim().toLowerCase().equals("true")) {
                    if (ses.equals("y")) {
                        session.setAttribute("mineQuery", (Object)"true");
                    } else {
                        Resources.MINE_QUERY = true;
                    }
                } else if (ses.equals("y")) {
                    session.setAttribute("mineQuery", (Object)"false");
                } else {
                    Resources.MINE_QUERY = false;
                }
            }
            catch (Exception e) {
                System.out.println("*** ERROR READING PROPERTY 'MINE QUERY'! THIS PROPERTY WAS NOT LOADED! ");
            }
            HashSet<String> acceptedCats = new HashSet<String>();
            String acceptedCategories = prop.getProperty("gr.forth.ics.isl.xsearch.resources.mining.acceptedCategories");
            for (String acceptedCategory : acceptedCategoriesArray = acceptedCategories.split(",")) {
                if (acceptedCategory.trim().equals("")) continue;
                acceptedCats.add(acceptedCategory.trim());
            }
            if (ses.equals("y")) {
                session.setAttribute("acceptedCategories", acceptedCats);
            } else {
                Resources.MINING_ACCEPTED_CATEGORIES = new HashSet();
                Resources.MINING_ACCEPTED_CATEGORIES.addAll(acceptedCats);
            }
            HashMap<String, String> endpoints = new HashMap<String, String>();
            HashMap<String, String> templates = new HashMap<String, String>();
            for (String acceptedCategory : acceptedCats) {
                String sparqlTemplate;
                String sparqlEndpoint = prop.getProperty("gr.forth.ics.isl.xsearch.resources.entityenrichment.sparqlendpoint." + acceptedCategory);
                if (sparqlEndpoint != null) {
                    endpoints.put(acceptedCategory, sparqlEndpoint.trim());
                }
                if ((sparqlTemplate = prop.getProperty("gr.forth.ics.isl.xsearch.resources.entityenrichment.templatequery." + acceptedCategory)) == null) continue;
                templates.put(acceptedCategory, sparqlTemplate.trim());
            }
            if (ses.equals("y")) {
                session.setAttribute("endpoints", endpoints);
                session.setAttribute("templateQueries", templates);
            } else {
                Resources.SPARQL_ENDPOINTS = new HashMap();
                Resources.SPARQL_ENDPOINTS.putAll(endpoints);
                Resources.SPARQL_TEMPLATES = new HashMap();
                Resources.SPARQL_TEMPLATES.putAll(templates);
            }
            System.out.println("# The configuration file with ID = " + id + " was successfully loaded!");
        }
        catch (Exception e) {
            out.print(e.getMessage().replace("\n", " "));
        }
        in.close();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

