/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch.mining;

import gr.forth.ics.isl.textentitymining.Category;
import gr.forth.ics.isl.textentitymining.Entity;
import gr.forth.ics.isl.textentitymining.gate.GateEntityMiner;
import gr.forth.ics.isl.xsearch.IOSLog;
import gr.forth.ics.isl.xsearch.SearchResult;
import gr.forth.ics.isl.xsearch.util.EditDistance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class Mining {
    private ArrayList<SearchResult> wseResults;
    private ArrayList<Category> entities;
    private String query;
    private HashSet<String> categoriesInQuery;
    private ArrayList<Category> entitiesInQuery;
    private String statistics;
    private HashSet<String> acceptedCategories;
    private HashMap<String, String> endpoints;
    private HashMap<String, String> templateQueries;

    public Mining(ArrayList<SearchResult> wseResults, String query, HashSet<String> acceptedCategories, HashMap<String, String> endpoints, HashMap<String, String> templateQueries) {
        this.wseResults = wseResults;
        this.query = query;
        this.acceptedCategories = acceptedCategories;
        this.endpoints = endpoints;
        this.templateQueries = templateQueries;
        ArrayList<String> contentsToMine = new ArrayList<String>();
        for (SearchResult wse_res : wseResults) {
            String content = wse_res.getContent();
            contentsToMine.add(content);
        }
        GateEntityMiner miner = new GateEntityMiner();
        miner.setAcceptedCategories(acceptedCategories);
        miner.setCollectionToMine(contentsToMine);
        miner.findEntities();
        this.entities = miner.getEntities();
    }

    public void mineQuery() {
        this.findQueryCategories();
        for (String category : this.categoriesInQuery) {
            for (int k = 0; k < this.entities.size(); ++k) {
                if (!((Category)this.entities.get(k)).getName().trim().toLowerCase().equals(category.toLowerCase())) continue;
                ((Category)this.entities.get(k)).increaseRank();
            }
        }
        this.findQueryEntities();
        for (int k = 0; k < this.entities.size(); ++k) {
            String cat = ((Category)this.entities.get(k)).getName();
            for (int l = 0; l < this.entitiesInQuery.size(); ++l) {
                String q_cat = ((Category)this.entitiesInQuery.get(l)).getName();
                if (!cat.equals(q_cat)) continue;
                ((Category)this.entities.get(k)).increaseRank();
                for (int q = 0; q < ((Category)this.entities.get(k)).getEntities().size(); ++q) {
                    String name = ((Entity)((Category)this.entities.get(k)).getEntities().get(q)).getName();
                    for (int r = 0; r < ((Category)this.entitiesInQuery.get(l)).getEntities().size(); ++r) {
                        String qname = ((Entity)((Category)this.entitiesInQuery.get(l)).getEntities().get(r)).getName();
                        if (name.toLowerCase().contains(qname.toLowerCase())) {
                            ((Entity)((Category)this.entities.get(k)).getEntities().get(q)).increaseRank(50);
                        }
                        if (!name.toLowerCase().equals(qname.toLowerCase())) continue;
                        ((Entity)((Category)this.entities.get(k)).getEntities().get(q)).increaseRank(50);
                    }
                }
            }
        }
    }

    private void findQueryEntities() {
        try {
            GateEntityMiner queryMiner = new GateEntityMiner();
            queryMiner.setAcceptedCategories((Set)this.acceptedCategories);
            queryMiner.setTextToMine(this.query);
            queryMiner.findEntities();
            this.entitiesInQuery = queryMiner.getEntities();
            System.out.println("# Entities in query: " + this.entitiesInQuery.size());
        }
        catch (Exception ex) {
            IOSLog.writeErrorToLog((Exception)ex, (String)"Mining");
            System.out.println("*** PROBLEM ADDING DOCUMENTS TO CORPUS:");
        }
    }

    private void findQueryCategories() {
        this.categoriesInQuery = new HashSet();
        String q = this.query;
        while (q.contains("  ")) {
            q = q.replace("  ", " ");
        }
        q = q.trim().toLowerCase();
        String[] words = q.split(" ");
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            for (String category : this.acceptedCategories) {
                int edit_dist = EditDistance.getLevenshteinDistance((String)word, (String)category);
                if (category.length() <= 4) {
                    if (edit_dist > 1) continue;
                    this.categoriesInQuery.add(category);
                    continue;
                }
                if (edit_dist > 2) continue;
                this.categoriesInQuery.add(category);
            }
        }
        System.out.println("# Categories in query: " + this.categoriesInQuery);
    }

    public void giveRankToElements(int max_num_of_results_from_wse) {
        for (int i = 0; i < this.entities.size(); ++i) {
            Category category = (Category)this.entities.get(i);
            for (int j = 0; j < category.getEntities().size(); ++j) {
                Entity entity = (Entity)category.getEntities().get(j);
                for (int k = 0; k < entity.getDocIds().size(); ++k) {
                    int doc_id = (Integer)entity.getDocIds().get(k);
                    SearchResult result = (SearchResult)this.wseResults.get(doc_id);
                    int doc_rank = result.getRank();
                    ((Entity)((Category)this.entities.get(i)).getEntities().get(j)).increaseRank(max_num_of_results_from_wse - doc_rank);
                }
            }
        }
    }

    public void createEntitiesHTMLFormat() {
        int total_entities = 0;
        System.out.println("=> Number of categories: " + this.entities.size());
        this.statistics = "=> Number of categories: " + this.entities.size() + ".\n";
        for (int k = 0; k < this.entities.size(); ++k) {
            String one_entity = "";
            String category = ((Category)this.entities.get(k)).getName();
            ArrayList els = ((Category)this.entities.get(k)).getEntities();
            int num_of_elements = els.size();
            total_entities += num_of_elements;
            Collections.sort(((Category)this.entities.get(k)).getEntities());
            HashSet<String> distinct_docs = new HashSet<String>();
            if (category.equals("Address")) {
                category = "Mail / URL / Tel";
            }
            one_entity = one_entity + "<div class=\"one_entity\"><span class=\"em_category_name\">" + category.replace("_", " ") + "</span>";
            one_entity = num_of_elements == 1 ? one_entity + "<span class=\"em_num_of_entities\"> (" + num_of_elements + " entity)</span>" : one_entity + "<span class=\"em_num_of_entities\"> (" + num_of_elements + " entities)</span>";
            one_entity = one_entity + "<br />";
            int num = 0;
            for (int i = 0; i < num_of_elements; ++i) {
                String element_name;
                ++num;
                Entity entity = (Entity)els.get(i);
                int size = entity.getDocIds().size();
                String docIds = "";
                for (int j = 0; j < size; ++j) {
                    int id = (Integer)entity.getDocIds().get(j);
                    SearchResult res = (SearchResult)this.wseResults.get(id);
                    String url = res.getUrl();
                    distinct_docs.add(url);
                    docIds = docIds + id;
                    if (j == size - 1) continue;
                    docIds = docIds + ",";
                }
                String element_name_cut = element_name = entity.getName();
                String element_name_pass = element_name.replace("\"", "&quot;").replace("'", "&quot;").replace("%", "^^^^^");
                String element_id = category.toLowerCase().trim() + "_" + num;
                String element_img_id = category.toLowerCase().trim().replace(" ", "_").replace(".", "") + "_img_" + num;
                if (element_name.length() > 24) {
                    element_name_cut = element_name.substring(0, 23) + "...";
                }
                String id_el_name = k + "_" + i;
                String id_href_name = "img_" + id_el_name;
                String link_href_name = "a_" + id_el_name;
                if (num > 10) {
                    String id_name = category + "_hidden_entities";
                    String show_name = category + "_show_all";
                    if (num == 11) {
                        one_entity = one_entity + "<div id=\"" + id_name + "\" style=\"display:none\">";
                    }
                    one_entity = one_entity + "<a id=\"" + id_href_name + "\" style=\"display:none\" href=\"javascript:unloadEntityResults('" + category + "', '" + element_name_pass + "', '" + docIds + "', '" + id_el_name + "')\"><img border=\"0\" src=\"files/graphics/remove.gif\"/></a>&nbsp;";
                    one_entity = one_entity + "<a id=\"" + link_href_name + "\" title=\"" + element_name + "\" href=\"javascript:loadEntityResults('" + category + "', '" + element_name_pass + "', '" + docIds + "', '" + id_el_name + "')\">";
                    one_entity = one_entity + "<font id=\"" + id_el_name + "\" class=\"em_element_name\">" + element_name_cut;
                    one_entity = one_entity + " (" + size + ")";
                    one_entity = one_entity + "</font></a>";
                    if (this.templateQueries.containsKey(category)) {
                        one_entity = one_entity + "&nbsp;<a id=\"" + element_img_id + "\" href=\"javascript:inspectElement('" + category + "', '" + element_name_pass + "', '" + element_img_id + "')\"><img border=\"0\" title=\"Click to retrieve LOD\" src=\"files/graphics/lod.jpg\"/></a>";
                    }
                    one_entity = one_entity + "<br />";
                    if (num != num_of_elements) continue;
                    one_entity = one_entity + "</div>";
                    one_entity = one_entity + "<div id=\"" + show_name + "\" align=\"right\" class=\"em_show_name \"><a href=\"javascript:showAll('" + id_name + "', '" + show_name + "')\" class=\"em_show_name_a\">show all</a></div>";
                    continue;
                }
                one_entity = one_entity + "<a id=\"" + id_href_name + "\" style=\"display:none\" href=\"javascript:unloadEntityResults('" + category + "', '" + element_name_pass + "', '" + docIds + "', '" + id_el_name + "')\"><img border=\"0\" src=\"files/graphics/remove.gif\"/></a>&nbsp;";
                one_entity = one_entity + "<a id=\"" + link_href_name + "\" title=\"" + element_name + "\" href=\"javascript:loadEntityResults('" + category + "', '" + element_name_pass + "', '" + docIds + "', '" + id_el_name + "')\">";
                one_entity = one_entity + "<font id=\"" + id_el_name + "\" class=\"em_element_name\">" + element_name_cut;
                one_entity = one_entity + " (" + size + ")";
                one_entity = one_entity + "</font></a>";
                if (this.templateQueries.containsKey(category)) {
                    one_entity = one_entity + "&nbsp;<a id=\"" + element_img_id + "\" href=\"javascript:inspectElement('" + category + "', '" + element_name_pass + "', '" + element_img_id + "')\"><img border=\"0\" title=\"Click to retrieve LOD\" src=\"files/graphics/lod.jpg\"/></a>";
                }
                one_entity = one_entity + "<br />";
            }
            one_entity = one_entity + "</div>";
            one_entity = one_entity.replace("'", "&quot;").replace("\n", " ").replace("\r", " ").replace("\t", " ");
            ((Category)this.entities.get(k)).setNum_of_different_docs(distinct_docs.size());
            ((Category)this.entities.get(k)).setCategory_representation(one_entity);
        }
        System.out.println("=> Number of entities in all categories: " + total_entities);
        this.statistics = this.statistics + "=> Number of entities in all categories: " + total_entities + ".\n";
    }

    public HashSet<String> getCategoriesInQuery() {
        return this.categoriesInQuery;
    }

    public void setCategoriesInQuery(HashSet<String> categoriesInQuery) {
        this.categoriesInQuery = categoriesInQuery;
    }

    public ArrayList<Category> getEntities() {
        return this.entities;
    }

    public void setEntities(ArrayList<Category> entities) {
        this.entities = entities;
    }

    public ArrayList<Category> getEntitiesInQuery() {
        return this.entitiesInQuery;
    }

    public void setEntitiesInQuery(ArrayList<Category> entitiesInQuery) {
        this.entitiesInQuery = entitiesInQuery;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public ArrayList<SearchResult> getWseResults() {
        return this.wseResults;
    }

    public void setWseResults(ArrayList<SearchResult> wseResults) {
        this.wseResults = wseResults;
    }

    public String getStatistics() {
        return this.statistics;
    }

    public void setStatistics(String statistics) {
        this.statistics = statistics;
    }
}

