/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch.retriever;

import gr.forth.ics.isl.xsearch.SearchResult;
import gr.forth.ics.isl.xsearch.resources.Resources;
import gr.forth.ics.isl.xsearch.retriever.ResultsRetriever;
import gr.forth.ics.isl.xsearch.util.HTMLTag;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;

public class AtomRetriever
implements ResultsRetriever {
    private String url;
    private String query;
    private String queryAttribute;
    private int desiredNumber;
    private HashMap<String, String> parameters;
    private ArrayList<SearchResult> results;

    public AtomRetriever(String url) {
        this.url = url;
        this.queryAttribute = null;
        this.query = null;
        this.desiredNumber = -1;
        this.parameters = new HashMap();
        this.results = new ArrayList();
    }

    public void retrieveResults() {
        try {
            if (this.desiredNumber <= 0) {
                this.desiredNumber = Resources.MAX_NUM_OF_RESULTS_FROM_WSE;
            }
            String queryPath = this.url;
            if (this.query != null && this.queryAttribute != null) {
                String encQuery = URLEncoder.encode(this.query, "utf-8");
                queryPath = !queryPath.contains("?") ? queryPath + "?" : queryPath + "&";
                queryPath = queryPath + this.queryAttribute + "=" + encQuery;
            }
            if (!this.parameters.isEmpty()) {
                if (!queryPath.contains("?")) {
                    queryPath = queryPath + "?";
                }
                String paramsString = "";
                for (String paramKey : this.parameters.keySet()) {
                    String paramValue = (String)this.parameters.get(paramKey);
                    paramsString = paramsString + "&" + paramKey + "=" + paramValue;
                }
                queryPath = queryPath + paramsString;
            }
            System.out.println("# QUERY PATH: " + queryPath);
            URL theurl = new URL(queryPath);
            HTMLTag tagger = new HTMLTag(theurl, true);
            int i1 = tagger.getFirstTagIndex("entry");
            int num = 1;
            while (i1 != -1) {
                String link;
                String title = tagger.getFirstTagData("title", i1);
                if (title == null) {
                    title = "";
                }
                if ((link = tagger.getFirstTagContentContains("link", "http", i1)) == null && (link = tagger.getFirstTagContent("link", i1)) == null) {
                    link = "#";
                }
                if ((link = HTMLTag.getHref((String)link)) == null) {
                    link = "#";
                } else if (link.trim().equals("")) {
                    link = "#";
                }
                String description = tagger.getFirstTagData("summary", i1);
                if (description == null) {
                    description = "";
                }
                SearchResult result = new SearchResult(title, link, description, num);
                this.results.add(result);
                if (num != this.desiredNumber) {
                    ++num;
                    i1 = tagger.getFirstTagIndex("entry", i1 + 2);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println("*** ERROR RETRIEVING RESULTS: " + e.getMessage());
        }
    }

    public ArrayList<SearchResult> getResults() {
        return this.results;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }

    public void setDesiredNumber(int desiredNumber) {
        this.desiredNumber = desiredNumber;
    }

    public int getDesiredNumber() {
        return this.desiredNumber;
    }

    public void setParameters(HashMap<String, String> parameters) {
        this.parameters = parameters;
    }

    public HashMap<String, String> getParameters() {
        return this.parameters;
    }

    public void setQueryAttribute(String queryAttribute) {
        this.queryAttribute = queryAttribute;
    }

    public String getQueryAttribute() {
        return this.queryAttribute;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }
}

