/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch.opensearch;

import gr.forth.ics.isl.xsearch.util.HTMLTag;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;

public class DescriptionDocument {
    private String path;
    private String shortName;
    private String description;
    private String inputEncoding;
    private String exampleQuery;
    private HashMap<String, String> urlTemplates;
    private String content;
    private boolean errorReadingDocument = false;

    public DescriptionDocument(String path) throws MalformedURLException, FileNotFoundException, UnsupportedEncodingException, IOException {
        this.path = path;
        this.urlTemplates = new HashMap();
        if (path.toLowerCase().startsWith("http")) {
            this.readHttpContent();
        } else {
            this.readFileContent();
        }
        this.readDescriptionDocument();
    }

    private void readDescriptionDocument() {
        HTMLTag tagger = new HTMLTag(this.content);
        this.shortName = tagger.getFirstTagData("shortName");
        if (this.shortName == null) {
            this.shortName = "-";
        }
        this.description = tagger.getFirstTagData("Description");
        if (this.description == null) {
            this.description = "-";
        }
        this.inputEncoding = tagger.getFirstTagData("InputEncoding");
        String exampleQueryTmp = tagger.getFirstTagContentContains("Query", "role=\"example\"");
        if (exampleQueryTmp != null) {
            this.exampleQuery = HTMLTag.getContentAttribute((String)"searchTerms", (String)exampleQueryTmp);
            if (this.exampleQuery == null) {
                this.exampleQuery = "";
            }
        }
        int ind = tagger.getFirstTagIndex("Url");
        while (ind != -1) {
            String urlContent = tagger.getFirstTagContent("Url", ind - 1).trim();
            String type = HTMLTag.getContentAttribute((String)"type", (String)urlContent).trim();
            String template = HTMLTag.getContentAttribute((String)"template", (String)urlContent).trim();
            this.urlTemplates.put(type, template);
            ind = tagger.getFirstTagIndex("Url", ind + 2);
        }
    }

    private void readFileContent() throws FileNotFoundException, UnsupportedEncodingException, IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.path), "UTF8"));
        this.content = "";
        while ((line = in.readLine()) != null) {
            this.content = this.content + line + "\n";
        }
        in.close();
    }

    private void readHttpContent() throws MalformedURLException {
        URL theurl = new URL(this.path);
        HTMLTag tagger = new HTMLTag(theurl, true);
        this.content = tagger.getSourceCode();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getInputEncoding() {
        return this.inputEncoding;
    }

    public void setInputEncoding(String inputEncoding) {
        this.inputEncoding = inputEncoding;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public HashMap<String, String> getUrlTemplates() {
        return this.urlTemplates;
    }

    public void setUrlTemplates(HashMap<String, String> urlTemplates) {
        this.urlTemplates = urlTemplates;
    }

    public String getExampleQuery() {
        return this.exampleQuery;
    }

    public void setExampleQuery(String exampleQuery) {
        this.exampleQuery = exampleQuery;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public boolean isErrorReadingDocument() {
        return this.errorReadingDocument;
    }

    public void setErrorReadingDocument(boolean errorReadingDocument) {
        this.errorReadingDocument = errorReadingDocument;
    }
}

