/*
 * Decompiled with CFR 0.152.
 */
package org.grade.engine;

import com.fasterxml.jackson.annotation.JsonValue;
import lombok.NonNull;
import org.grade.common.GradeUtils;

public enum ExecutionPhase {
    startup("startup"),
    transformation("transformation"),
    difference("difference"),
    writeout("writeout");

    @NonNull
    String uri;

    @JsonValue
    public String uri() {
        return this.uri;
    }

    public static ExecutionPhase status(String uri) {
        GradeUtils.validUri((String)"invalid operation", (String)uri);
        switch (uri) {
            case "startup": {
                return startup;
            }
            case "transformation": {
                return transformation;
            }
            case "difference": {
                return difference;
            }
            case "writeout": {
                return writeout;
            }
        }
        throw new IllegalArgumentException("unknown phase " + uri);
    }

    private ExecutionPhase(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri is null");
        }
        this.uri = uri;
    }

    static class Names {
        static final String startup_name = "startup";
        static final String transformation_name = "transformation";
        static final String difference_name = "difference";
        static final String writeout_name = "writeout";

        Names() {
        }
    }
}

