/*
 * Decompiled with CFR 0.152.
 */
package org.grade.engine;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.tdb.TDBFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import lombok.NonNull;
import org.grade.common.GradeUtils;
import org.grade.common.events.ApplicationEvent;
import org.grade.repo.QueryTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class Sandbox
implements QueryTarget {
    private static final Logger log = LoggerFactory.getLogger(Sandbox.class);
    private static Dataset dataset;
    private static Path location;
    private String graph;

    public synchronized QueryExecution executionFor(Query query) {
        if (location == null) {
            throw new IllegalStateException("cannot use sandbox, it's been disposed already");
        }
        return QueryExecutionFactory.create((Query)query, (Dataset)dataset);
    }

    public Sandbox(@NonNull String graph, @NonNull Model model) {
        if (graph == null) {
            throw new IllegalArgumentException("graph is null");
        }
        if (model == null) {
            throw new IllegalArgumentException("model is null");
        }
        this.graph = graph;
        GradeUtils.time((String)("stored sandbox " + graph), __ -> dataset.addNamedModel(graph, model));
    }

    public synchronized void dispose() {
        try {
            if (dataset.containsNamedModel(this.graph)) {
                dataset.removeNamedModel(this.graph);
                log.trace("disposed sandbox {}", (Object)this.graph);
            }
        }
        catch (Exception e) {
            log.warn("cannot dispose sandbox " + this.graph, (Throwable)e);
        }
    }

    static void createSandbox(@Observes ApplicationEvent.Startup event) {
        try {
            location = Files.createTempDirectory("grade-sandbox-", new FileAttribute[0]);
            dataset = TDBFactory.createDataset((String)location.toString());
            log.info("created sandbox @ {}", (Object)location);
        }
        catch (Exception e) {
            throw GradeUtils.unchecked((String)"cannot create sandbox at startup", (Throwable)e);
        }
    }

    static void disposeSandbox(@Observes ApplicationEvent.Shutdown event) {
        try {
            dataset.close();
            if (location != null && Files.exists(location, new LinkOption[0])) {
                GradeUtils.deleteDir((Path)location);
            }
            log.info("disposed sandbox @ {}", (Object)location);
        }
        catch (Exception e) {
            log.warn("cannot dispose sandbox on shutdown", (Throwable)e);
        }
    }

    private Sandbox() {
    }

    public String graph() {
        return this.graph;
    }
}

