/*
 * Decompiled with CFR 0.152.
 */
package org.sticky;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.fao.fi.comet.mapping.model.MappingData;
import org.fao.fi.comet.mapping.model.utils.jaxb.JAXBDeSerializationUtils;
import org.geotoolkit.data.FeatureCollection;
import org.geotoolkit.data.FeatureStoreUtilities;
import org.geotoolkit.feature.type.FeatureType;
import org.geotoolkit.feature.xml.jaxp.JAXPStreamFeatureWriter;
import org.grade.client.upload.Deployment;
import org.grade.client.upload.Grade;
import org.grade.client.upload.csv.Csv;
import org.opengis.feature.Feature;
import org.virtualrepository.Property;
import org.virtualrepository.VirtualRepository;
import org.virtualrepository.csv.CsvAsset;
import org.virtualrepository.csv.CsvTable;
import org.virtualrepository.impl.Repository;
import org.virtualrepository.ows.Features;
import org.virtualrepository.tabular.Column;
import org.virtualrepository.tabular.Row;
import org.virtualrepository.tabular.Table;
import org.w3c.dom.Document;

public class Common {
    public static VirtualRepository repository = new Repository();

    public static String file(String name) {
        return "src/main/resources/" + name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(String name, InputStream stream) {
        byte[] bytes = new byte[2048];
        File dest = new File(Common.file(name));
        FileOutputStream out = new FileOutputStream(dest);
        try {
            int read = 0;
            while ((read = stream.read(bytes)) != -1) {
                out.write(bytes, 0, read);
            }
            out.flush();
        }
        finally {
            if (Collections.singletonList(out).get(0) != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeFeatures(String name, Features features) {
        FileOutputStream out = new FileOutputStream(new File(Common.file(name)));
        try {
            JAXPStreamFeatureWriter featureWriter = new JAXPStreamFeatureWriter();
            ArrayList<org.geotoolkit.feature.Feature> geotkFeatures = new ArrayList<org.geotoolkit.feature.Feature>();
            for (Feature f : features.all()) {
                geotkFeatures.add((org.geotoolkit.feature.Feature)f);
            }
            FeatureCollection fc = FeatureStoreUtilities.collection((FeatureType)((FeatureType)((Feature)features.all().get(0)).getType()), geotkFeatures);
            featureWriter.write((Object)fc, (Object)out);
        }
        finally {
            if (Collections.singletonList(out).get(0) != null) {
                ((OutputStream)out).close();
            }
        }
    }

    public static void storeTable(String name, Table table) {
        Common.storeTable(name, table, Grade.csv());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeTable(String name, Table table, Csv info) {
        File file = new File(Common.file(name));
        FileOutputStream os = new FileOutputStream(file);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, info.encoding());
        BufferedWriter bufferedWriter = new BufferedWriter(osw);
        try {
            List columns = table.columns();
            for (int i = 0; i < columns.size(); ++i) {
                bufferedWriter.append(((Column)columns.get(i)).name().toString());
                if (i >= columns.size() - 1) continue;
                bufferedWriter.append(info.delimiter());
            }
            bufferedWriter.newLine();
            Iterator it = table.iterator();
            while (it.hasNext()) {
                Row row = (Row)it.next();
                for (int i = 0; i < columns.size(); ++i) {
                    bufferedWriter.append(row.get((Column)columns.get(i)));
                    if (i >= columns.size() - 1) continue;
                    bufferedWriter.append(info.delimiter());
                }
                if (!it.hasNext()) continue;
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
        }
        finally {
            if (Collections.singletonList(bufferedWriter).get(0) != null) {
                bufferedWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeMapping(String name, MappingData mapping) {
        String xml = JAXBDeSerializationUtils.toXML((MappingData)mapping);
        File dest = new File(Common.file(name));
        FileOutputStream out = new FileOutputStream(dest);
        try {
            out.write(xml.getBytes());
            out.flush();
        }
        finally {
            if (Collections.singletonList(out).get(0) != null) {
                out.close();
            }
        }
    }

    public static InputStream load(String name) {
        return new FileInputStream(Common.file(name));
    }

    public static Table loadTable(String file) {
        return Common.loadTable(file, Grade.csv());
    }

    public static Table loadTable(String file, Csv info) {
        CsvAsset a = new CsvAsset("someid", "somename", new Property[0]);
        a.hasHeader(true);
        a.setDelimiter(info.delimiter());
        a.setEncoding(Charset.forName(info.encoding()));
        a.setQuote(info.quote());
        return new CsvTable(a, Common.load(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MappingData loadMapping(String name) {
        MappingData mappingData;
        block6: {
            InputStream is = Common.load(name);
            try {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(is);
                doc.getDocumentElement().normalize();
                mappingData = JAXBDeSerializationUtils.fromDocument((Document)doc);
                if (Collections.singletonList(is).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(is).get(0) != null) {
                    is.close();
                }
                throw throwable;
            }
            is.close();
        }
        return mappingData;
    }

    public static enum TestDeployment implements Deployment
    {
        ami("http://grade.ddns.net:8080", "staging"),
        preproduction("http://figisapps/grade", "staging");

        final String uri;
        final String endpoint;

        private TestDeployment(String uri, String endpoint) {
            this.uri = uri;
            this.endpoint = endpoint;
        }

        public String uri() {
            return this.uri;
        }

        public String endpoint() {
            return this.endpoint;
        }
    }
}

