/*
 * Decompiled with CFR 0.152.
 */
package org.sticky;

import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.xml.namespace.QName;
import org.fao.fi.comet.mapping.model.MappingData;
import org.glassfish.jersey.filter.LoggingFilter;
import org.grade.client.upload.Deployment;
import org.grade.client.upload.Grade;
import org.grade.client.upload.UploadType;
import org.grade.client.upload.csv.Csv;
import org.junit.Test;
import org.sticky.Common;
import org.sticky.aux.AdminUnits;
import org.sticky.aux.Eezs;
import org.sticky.aux.FsaHierarchy;
import org.sticky.aux.SpeciesDistribution;
import org.sticky.aux.Worms;
import org.virtualrepository.Asset;
import org.virtualrepository.Property;
import org.virtualrepository.RepositoryService;
import org.virtualrepository.ows.Features;
import org.virtualrepository.ows.WfsFeatureType;
import org.virtualrepository.tabular.Table;

public class Glues {
    @Test
    public void grabRfb() {
        InputStream rfb = (InputStream)((Client)ClientBuilder.newClient().register((Object)new LoggingFilter(Logger.getLogger(LoggingFilter.class.getName()), true))).target(URI.create("http://www.fao.org/figis/moniker/figismapdata")).request().get(InputStream.class);
        Common.store("rfb.xml", rfb);
    }

    @Test
    public void pushRfb() {
        Grade.drop((String)Common.file("rfb.xml")).with(Grade.xml).in((Deployment)Common.TestDeployment.ami).as("rfb");
    }

    @Test
    public void grabAdminUnits() {
        Table countries = Common.loadTable("gaul-codes.txt");
        Table flagstates = Common.loadTable("flagstates.txt", Grade.csv().delimiter(';'));
        Table names = Common.loadTable("gaul-names.txt", Grade.csv().delimiter('\t').encoding("UTF-16"));
        countries = AdminUnits.enrichAdminUnitsTable(countries, flagstates);
        countries = AdminUnits.buildAdminUnitsTable(countries, names);
        Common.storeTable("admin-units.txt", countries, Grade.csv().encoding("UTF-16"));
    }

    @Test
    public void pushAdminUnits() {
        Csv csv = Grade.csv().delimiter(',').encoding("UTF-16");
        Grade.drop((String)Common.file("admin-units.txt")).with((UploadType)csv).in((Deployment)Common.TestDeployment.ami).as("admin-units");
    }

    @Test
    public void grabEez() {
        Features eez = Eezs.eezs();
        Common.storeFeatures("eez.xml", eez);
    }

    @Test
    public void pushEez() {
        Grade.drop((String)Common.file("eez.xml")).with(Grade.xml).in((Deployment)Common.TestDeployment.ami).as("eez");
    }

    @Test
    public void grabMappingSovereignty() {
        Features eezs = Eezs.eezs();
        Map<String, List<String>> codelist = Eezs.buildEmbeddedCodelist(eezs);
        MappingData mapping = Eezs.buildMappingSovereignty(eezs, codelist);
        Common.storeMapping("eez-country-sovereignty.xml", mapping);
    }

    @Test
    public void pushMappingSovereignty() {
        Grade.drop((String)Common.file("eez-country-sovereignty.xml")).with(Grade.xml).in((Deployment)Common.TestDeployment.ami).as("eez-country-sovereignty");
    }

    @Test
    public void grabMappingExploitation() {
        Table adminUnits = Common.loadTable("admin-units.txt", Grade.csv().encoding("UTF-16"));
        Features eezs = Eezs.eezs();
        Map<String, List<String>> codelist = Eezs.buildEmbeddedCodelist(eezs);
        MappingData mapping = Eezs.buildMappingExploitation(eezs, codelist, adminUnits);
        Common.storeMapping("eez-flagstate-exploitation.xml", mapping);
    }

    @Test
    public void pushMappingExploitation() {
        Grade.drop((String)Common.file("eez-flagstate-exploitation.xml")).with(Grade.xml).in((Deployment)Common.TestDeployment.ami).as("eez-flagstate-exploitation");
    }

    @Test
    public void grabFsaHierarchy() {
        RepositoryService faoareas = Common.repository.services().lookup(new QName("fao-areas"));
        WfsFeatureType asset = new WfsFeatureType("fifao-areas", "fifao:FAO_AREAS", new Property[0]);
        asset.setService(faoareas);
        Features features = (Features)Common.repository.retrieve((Asset)asset, Features.class);
        Features trgFeatures = FsaHierarchy.buildFsaHierarchy(features);
        Common.storeFeatures("fao-areas.xml", trgFeatures);
    }

    @Test
    public void pushFsaHierarchy() {
        Grade.drop((String)Common.file("fao-areas.xml")).with(Grade.xml).in((Deployment)Common.TestDeployment.ami).as("fsa-hierarchy");
    }

    @Test
    public void grabSpeciesDistributions() {
        String ep = "http://www.fao.org/figis/geoserver/species/ows";
        MappingData out = SpeciesDistribution.buildGeographicReferences(ep);
        Common.storeMapping("species-distributions.xml", out);
    }

    @Test
    public void pushSpeciesDistributions() {
        Grade.drop((String)Common.file("species-distributions.xml")).with(Grade.xml).in((Deployment)Common.TestDeployment.ami).as("species-distributions");
    }

    @Test
    public void grabEezFsa() {
        RepositoryService intersections = Common.repository.services().lookup(new QName("intersections"));
        WfsFeatureType asset = new WfsFeatureType("eez-fsa_intersection", "GeoRelationship:FAO_AREAS_x_EEZ_HIGHSEAS", new Property[0]);
        asset.setService(intersections);
        InputStream stream = (InputStream)Common.repository.retrieve((Asset)asset, InputStream.class);
        Common.store("intersections.xml", stream);
    }

    @Test
    public void pushEezFsa() {
        Grade.drop((String)Common.file("intersections.xml")).with(Grade.xml).in((Deployment)Common.TestDeployment.ami).as("eez-fsa_intersection");
    }

    @Test
    public void grabWormsHierarchy() {
        Table worms = Common.loadTable("worms-pisces.csv");
        MappingData wormsToAsfis = Common.loadMapping("worms-to-asfis.xml");
        Table outHierarchy = Worms.buildWormsTaxonomicHierarchy(wormsToAsfis, worms);
        Common.storeTable("worms-subset-hierarchy.txt", outHierarchy, Grade.csv().encoding("UTF-16").delimiter('\t'));
    }

    @Test
    public void pushWormsHierarchy() {
        Csv csv = Grade.csv().delimiter('\t').encoding("UTF-16");
        Grade.drop((String)Common.file("worms-subset-hierarchy.txt")).with((UploadType)csv).in((Deployment)Common.TestDeployment.ami).as("worms-subset-hierarchy");
    }

    @Test
    public void grabWormsCodelist() {
        Table worms = Common.loadTable("worms-pisces.csv");
        Table outHierarchy = Common.loadTable("worms-subset-hierarchy.txt", Grade.csv().delimiter('\t').encoding("UTF-16"));
        Table outSubset = Worms.buildWormsSubset(outHierarchy, worms);
        Common.storeTable("worms-subset-codelist.txt", outSubset, Grade.csv().encoding("UTF-16").delimiter('\t'));
    }

    @Test
    public void pushWormsCodelist() {
        Csv csv = Grade.csv().delimiter('\t').encoding("UTF-16");
        Grade.drop((String)Common.file("worms-subset-codelist.txt")).with((UploadType)csv).in((Deployment)Common.TestDeployment.ami).as("worms-subset-codelist");
    }
}

