/*
 * Decompiled with CFR 0.152.
 */
package org.sticky.aux;

import java.util.ArrayList;
import java.util.Iterator;
import org.geotoolkit.feature.FeatureTypeBuilder;
import org.geotoolkit.feature.simple.SimpleFeature;
import org.geotoolkit.feature.simple.SimpleFeatureBuilder;
import org.geotoolkit.feature.simple.SimpleFeatureType;
import org.geotoolkit.feature.type.GeometryType;
import org.opengis.feature.AttributeType;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureType;
import org.opengis.feature.Property;
import org.opengis.feature.PropertyType;
import org.virtualrepository.ows.Features;

public class FsaHierarchy {
    public static Features buildFsaHierarchy(Features features) {
        FeatureType srcFeatureType = ((Feature)features.all().get(0)).getType();
        FeatureTypeBuilder ftb = new FeatureTypeBuilder();
        ftb.setName(srcFeatureType.getName().toString());
        for (PropertyType prop : srcFeatureType.getProperties(false)) {
            if (prop instanceof GeometryType) {
                ftb.add(prop.getName().toString(), ((GeometryType)prop).getValueClass(), ((GeometryType)prop).getCoordinateReferenceSystem());
                continue;
            }
            if (!(prop instanceof AttributeType)) continue;
            String name = prop.getName().toString();
            if (name.equals("F_AREA") || name.equals("F_SUBAREA") || name.equals("F_DIVISION") || name.equals("F_SUBDIVIS") || name.equals("F_SUBUNIT")) {
                name = name.replaceFirst("F_", "PARTOF_");
            }
            System.out.println(name);
            ftb.add(name, ((AttributeType)prop).getValueClass());
        }
        SimpleFeatureType trgFeatureType = ftb.buildSimpleFeatureType();
        ArrayList<SimpleFeature> trgFeatureList = new ArrayList<SimpleFeature>();
        SimpleFeatureBuilder sfb = new SimpleFeatureBuilder(trgFeatureType);
        Iterator it = features.all().iterator();
        while (it.hasNext()) {
            FsaLevel parentFsaLevel;
            String partOf = null;
            Feature f = (Feature)it.next();
            String code = f.getPropertyValue("F_CODE").toString();
            String level = f.getPropertyValue("F_LEVEL").toString();
            FsaLevel fsaLevel = FsaLevel.valueOf(level);
            if (!fsaLevel.equals((Object)FsaLevel.MAJOR) && (partOf = f.getPropertyValue((parentFsaLevel = FsaLevel.values()[fsaLevel.ordinal() - 1]).attribute()).toString()).startsWith("_")) {
                partOf = partOf.substring(1, partOf.length());
            }
            for (PropertyType prop : trgFeatureType.getProperties(false)) {
                String propertyName = prop.getName().toString();
                if (propertyName.startsWith("PARTOF_")) {
                    propertyName = propertyName.replaceFirst("PARTOF_", "F_");
                }
                Property property = f.getProperty(propertyName);
                String value = null;
                if (property != null && !propertyName.equals(fsaLevel.attribute()) && (value = property.getValue().toString()).startsWith("_")) {
                    value = value.substring(1, value.length());
                }
                sfb.add(value);
            }
            trgFeatureList.add(sfb.buildFeature("fao-area-" + code));
        }
        Features trgFeatures = new Features(trgFeatureList);
        return trgFeatures;
    }

    public static enum FsaLevel {
        MAJOR("MAJOR", "F_AREA"),
        SUBAREA("SUBAREA", "F_SUBAREA"),
        DIVISION("DIVISION", "F_DIVISION"),
        SUBDIVISION("SUBDIVISION", "F_SUBDIVIS"),
        SUBUNIT("SUBUNIT", "F_SUBUNIT");

        private final String value;
        private final String attribute;

        private FsaLevel(String value, String attribute) {
            this.value = value;
            this.attribute = attribute;
        }

        public String value() {
            return this.value;
        }

        public String attribute() {
            return this.attribute;
        }

        public boolean before(FsaLevel fsa) {
            return this.ordinal() < fsa.ordinal();
        }
    }
}

