/*
 * Decompiled with CFR 0.152.
 */
package org.sticky.aux;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.client.WebTarget;
import org.fao.fi.comet.mapping.dsl.MappingDSL;
import org.fao.fi.comet.mapping.dsl.MappingDetailDSL;
import org.fao.fi.comet.mapping.dsl.MappingElementDSL;
import org.fao.fi.comet.mapping.model.Mapping;
import org.fao.fi.comet.mapping.model.MappingData;
import org.fao.fi.comet.mapping.model.MappingElement;
import org.fao.fi.comet.mapping.model.utils.jaxb.JAXB2DOMUtils;
import org.geotoolkit.wms.xml.v130.Identifier;
import org.geotoolkit.wms.xml.v130.Layer;
import org.geotoolkit.wms.xml.v130.MetadataURL;
import org.geotoolkit.wms.xml.v130.WMSCapabilities;
import org.glassfish.jersey.client.filter.EncodingFilter;
import org.glassfish.jersey.message.GZipEncoder;
import org.sticky.jaxb.Code;
import org.sticky.jaxb.Entity;
import org.sticky.jaxb.GeographicReference;
import org.w3c.dom.Element;

public class SpeciesDistribution {
    public static MappingData buildGeographicReferences(String endpoint) {
        Client client = (Client)((Client)((Client)ClientBuilder.newClient().register((Object)ContentTypeFixer.instance)).register(GZipEncoder.class)).register(EncodingFilter.class);
        WebTarget target = client.target(endpoint).queryParam("service", new Object[]{"wms"}).queryParam("version", new Object[]{"1.3.0"}).queryParam("request", new Object[]{"GetCapabilities"});
        WMSCapabilities capabilities = (WMSCapabilities)target.request().get(WMSCapabilities.class);
        MappingData mappingData = new MappingData();
        mappingData.setDescription("Mapping between LOD entities and geographic references from the following GIS collection: " + capabilities.getService().getTitle());
        mappingData.setVersion("1.0");
        mappingData.setProducedOn(new Date());
        mappingData.setProducedBy("Emmanuel Blondel");
        for (Layer layer : capabilities.getLayers()) {
            List ids;
            Identifier id = null;
            if (layer.getIdentifier().size() > 0 && (ids = layer.getIdentifier().stream().filter(p -> p.getAuthority().equals("FLOD")).collect(Collectors.toList())).size() > 0) {
                id = (Identifier)ids.get(0);
            }
            MetadataURL md = null;
            if (layer.getMetadataURL().size() > 0) {
                Predicate<MetadataURL> formatPred = p -> p.getFormat().equals("text/xml");
                Predicate<MetadataURL> typePred = p -> p.getType().equals("ISO19115:2003");
                List mds = layer.getMetadataURL().stream().filter(formatPred.and(typePred)).collect(Collectors.toList());
                if (mds.size() > 0) {
                    md = (MetadataURL)mds.get(0);
                }
            }
            if (id == null || md == null) continue;
            MappingElement source = MappingElementDSL.wrap((Element)JAXB2DOMUtils.asElement((Object)Entity.coding(new Code(id.getValue(), "uri", null))));
            Mapping mappingEntry = MappingDSL.map((MappingElement)source);
            mappingEntry.to(MappingDetailDSL.target((MappingElement)MappingElementDSL.wrap((Element)JAXB2DOMUtils.asElement((Object)GeographicReference.coding(new Code(md.getOnlineResource().getHref(), "uri", layer.getTitle()))))));
            mappingData.include(new Mapping[]{mappingEntry});
        }
        return mappingData;
    }

    private static class ContentTypeFixer
    implements ClientResponseFilter {
        static final ContentTypeFixer instance = new ContentTypeFixer();

        private ContentTypeFixer() {
        }

        public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
            if (responseContext.getHeaderString("Content-Type").contains("subtype=gml")) {
                responseContext.getHeaders().put((Object)"Content-Type", Arrays.asList("text/xml"));
            }
        }
    }
}

