/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.data.fao.io;

import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.virtual.data.fao.io.Results;
import org.virtual.data.fao.resources.ResourceType;
import org.w3c.dom.Element;

public class Request {
    private static final Logger log = LoggerFactory.getLogger(Request.class);
    private static final String baseURI = "http://data.fao.org/developers/api/v1/all/resources/";
    private static String showLanguage = "showLanguage";
    private static String page = "page";
    private static String pageSize = "pageSize";
    private static int pageSizeDefault = 100;
    private static String fields = "fields";
    private static String fieldsDefault = "mnemonic,description@*,properties.bk,uri,urn,uuid,label@*";
    private static ClientConfig configuration = new ClientConfig().property("jersey.config.client.connectTimeout", (Object)3000).property("jersey.config.client.readTimeout", (Object)5000);
    private WebTarget target = ClientBuilder.newClient((Configuration)configuration).target("http://data.fao.org/developers/api/v1/all/resources/");

    @Inject
    public Request() {
    }

    public <T> ExecuteClause<T> over(ResourceType<T> resource) {
        return new ExecuteClause<T>(resource);
    }

    public class ExecuteClause<T> {
        private final ResourceType<T> resource;

        public ExecuteClause(ResourceType<T> resource) {
            this.resource = resource;
        }

        public Collection<T> execute() throws Exception {
            Request.this.target = Request.this.target.path(this.resource.path()).queryParam(showLanguage, new Object[]{"true"}).queryParam(pageSize, new Object[]{pageSizeDefault}).queryParam(fields, new Object[]{fieldsDefault});
            ArrayList<T> results = new ArrayList<T>();
            int lastPage = 1;
            Results response = null;
            do {
                WebTarget nextTarget = Request.this.target.queryParam(page, new Object[]{lastPage});
                response = (Results)nextTarget.request(new MediaType[]{this.resource.media()}).get(Results.class);
                log.trace("requesting {}", (Object)nextTarget.getUri());
                for (Element element : response) {
                    results.add(this.resource.bind(element));
                }
                ++lastPage;
            } while (response.hasMore());
            return results;
        }
    }
}

