/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.files;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.virtual.files.Assets;
import org.virtual.files.Provider;
import org.virtual.files.index.AssetEntry;
import org.virtual.files.index.AssetIndex;
import org.virtualrepository.AssetType;
import org.virtualrepository.spi.Browser;
import org.virtualrepository.spi.MutableAsset;

public class BaseBrowser
implements Browser {
    private static final Logger log = LoggerFactory.getLogger(BaseBrowser.class);
    @NonNull
    Provider provider;

    public final Iterable<? extends MutableAsset> discover(Collection<? extends AssetType> types) throws Exception {
        AssetIndex index = this.provider.index();
        ArrayList<MutableAsset> assets = new ArrayList<MutableAsset>();
        for (AssetEntry $ : index.assets()) {
            if (!$.hasOneof(types)) continue;
            try {
                this.validate($);
                String id = index.id() + "-" + $.name().toString();
                assets.add(Assets.assetFor(id, $));
            }
            catch (Exception e) {
                log.warn("discarding invalid entry " + $, (Throwable)e);
            }
        }
        log.info("{} discovered {} assets from an index of {}", new Object[]{this, assets.size(), index.assets().size()});
        return assets;
    }

    void validate(AssetEntry entry) {
        AssetEntry.asset(entry.name(), entry.type(), entry.path());
        this.provider.validate(entry);
    }

    public String toString() {
        return this.provider.toString();
    }

    @ConstructorProperties(value={"provider"})
    public BaseBrowser(@NonNull Provider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider is null");
        }
        this.provider = provider;
    }
}

