/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.files;

import java.beans.ConstructorProperties;
import java.io.InputStream;
import lombok.NonNull;
import org.virtual.files.Provider;
import org.virtual.files.index.AssetEntry;
import org.virtualrepository.Asset;
import org.virtualrepository.Properties;
import org.virtualrepository.Property;
import org.virtualrepository.impl.Type;
import org.virtualrepository.spi.Importer;

public class BaseImporter
implements Importer<Asset, InputStream> {
    @NonNull
    Provider provider;

    public InputStream retrieve(Asset asset) throws Exception {
        AssetEntry entry = this.entryIn(asset);
        return this.provider.resolve(entry);
    }

    public Type<? extends Asset> type() {
        return Type.any;
    }

    public Class<InputStream> api() {
        return InputStream.class;
    }

    AssetEntry entryIn(Asset asset) {
        Properties props = asset.properties();
        if (!props.contains("vfile")) {
            throw new IllegalArgumentException("unresolvable asset: no property vfile");
        }
        Property property = props.lookup("vfile");
        if (!property.is(AssetEntry.class)) {
            throw new IllegalArgumentException("invalid asset: unexpdcted value for property vfile");
        }
        return (AssetEntry)property.value(AssetEntry.class);
    }

    @ConstructorProperties(value={"provider"})
    public BaseImporter(@NonNull Provider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider is null");
        }
        this.provider = provider;
    }
}

