/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.files;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import org.virtual.files.BaseBrowser;
import org.virtual.files.BaseImporter;
import org.virtual.files.Provider;
import org.virtual.files.transforms.ToTable;
import org.virtualrepository.Asset;
import org.virtualrepository.spi.ImportAdapter;
import org.virtualrepository.spi.Importer;
import org.virtualrepository.spi.Publisher;
import org.virtualrepository.spi.ServiceProxy;
import org.virtualrepository.spi.Transform;

public class BaseProxy
implements ServiceProxy {
    @NonNull
    BaseBrowser browser;
    List<Importer<?, ?>> importers = new ArrayList();
    List<Publisher<?, ?>> publishers = new ArrayList();

    public BaseProxy(Provider provider) {
        this.browser = new BaseBrowser(provider);
        BaseImporter base = new BaseImporter(provider);
        this.importers.addAll(Arrays.asList(base, this.adapt(base, new ToTable()), this.adapt(base, new ToTable())));
    }

    <A extends Asset, O> Importer<A, O> adapt(BaseImporter base, Transform<A, InputStream, O> transform) {
        BaseImporter safebase = base;
        return ImportAdapter.adapt((Importer)safebase, transform);
    }

    @NonNull
    public BaseBrowser browser() {
        return this.browser;
    }

    public List<Importer<?, ?>> importers() {
        return this.importers;
    }

    public List<Publisher<?, ?>> publishers() {
        return this.publishers;
    }
}

