/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.files.index;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import lombok.NonNull;
import org.virtualrepository.AssetType;

public class AssetEntry {
    @JsonProperty
    @NonNull
    private QName name;
    @JsonProperty
    @NonNull
    private String type;
    @JsonProperty
    private Map<String, String> properties = new HashMap<String, String>();
    @JsonProperty
    @NonNull
    private String path;

    public boolean hasOneof(Collection<? extends AssetType> types) {
        return types.stream().anyMatch($ -> $.name().equals(this.type));
    }

    @NonNull
    public QName name() {
        return this.name;
    }

    @NonNull
    public String type() {
        return this.type;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    @NonNull
    public String path() {
        return this.path;
    }

    public AssetEntry name(@NonNull QName name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
        return this;
    }

    public AssetEntry type(@NonNull String type) {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        this.type = type;
        return this;
    }

    public AssetEntry properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public AssetEntry path(@NonNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        this.path = path;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssetEntry)) {
            return false;
        }
        AssetEntry other = (AssetEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        QName this$name = this.name();
        QName other$name = other.name();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        String this$type = this.type();
        String other$type = other.type();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Map<String, String> this$properties = this.properties();
        Map<String, String> other$properties = other.properties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$path = this.path();
        String other$path = other.path();
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AssetEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QName $name = this.name();
        result = result * 59 + ($name == null ? 0 : ((Object)$name).hashCode());
        String $type = this.type();
        result = result * 59 + ($type == null ? 0 : $type.hashCode());
        Map<String, String> $properties = this.properties();
        result = result * 59 + ($properties == null ? 0 : ((Object)$properties).hashCode());
        String $path = this.path();
        result = result * 59 + ($path == null ? 0 : $path.hashCode());
        return result;
    }

    public String toString() {
        return "AssetEntry(name=" + this.name() + ", type=" + this.type() + ", properties=" + this.properties() + ", path=" + this.path() + ")";
    }

    private AssetEntry(@NonNull QName name, @NonNull String type, @NonNull String path) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        this.name = name;
        this.type = type;
        this.path = path;
    }

    public static AssetEntry asset(@NonNull QName name, @NonNull String type, @NonNull String path) {
        return new AssetEntry(name, type, path);
    }

    public AssetEntry() {
    }
}

