/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.files.local;

import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.virtual.files.Provider;
import org.virtual.files.common.Utils;
import org.virtual.files.config.LocalConfiguration;
import org.virtual.files.index.AssetEntry;
import org.virtual.files.index.AssetIndex;

public class LocalProvider
implements Provider {
    private static final Logger log = LoggerFactory.getLogger(LocalProvider.class);
    private AssetIndex index;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private LocalConfiguration config;

    public LocalProvider(@NonNull LocalConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException("config is null");
        }
        this.config = config;
        File indexfile = new File(config.location(), "vindex.json");
        this.index = this.parse(indexfile);
        this.executor.execute(new Watcher(indexfile));
    }

    @Override
    public void validate(AssetEntry entry) {
        Utils.valid(new File(this.config.location(), entry.path()));
    }

    @Override
    public InputStream resolve(AssetEntry entry) {
        try {
            return new FileInputStream(new File(this.config.location(), entry.path()));
        }
        catch (Exception e) {
            throw Utils.unchecked(e);
        }
    }

    public String toString() {
        return this.config.name() + "@" + this.config.location();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AssetIndex parse(File index) {
        AssetIndex assetIndex;
        block6: {
            FileInputStream stream = new FileInputStream(index);
            try {
                assetIndex = Utils.assetsFrom(stream);
                if (Collections.singletonList(stream).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(stream).get(0) != null) {
                    stream.close();
                }
                throw throwable;
            }
            stream.close();
        }
        return assetIndex;
    }

    @Override
    public AssetIndex index() {
        return this.index;
    }

    class Watcher
    implements Runnable {
        private final File indexfile;

        @Override
        public void run() {
            try {
                WatchService watcher = FileSystems.getDefault().newWatchService();
                try {
                    Path indexpath = Paths.get(this.indexfile.getPath(), new String[0]);
                    Path parentpath = indexpath.getParent();
                    parentpath.register(watcher, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE);
                    block4: while (true) {
                        WatchKey key = watcher.take();
                        Iterator<WatchEvent<?>> iterator = key.pollEvents().iterator();
                        while (true) {
                            boolean valid;
                            if (!iterator.hasNext()) continue block4;
                            WatchEvent<?> event = iterator.next();
                            if (event.kind() == StandardWatchEventKinds.OVERFLOW) continue;
                            WatchEvent<?> ev = event;
                            if (indexpath.equals(parentpath.resolve((Path)ev.context()))) {
                                log.info("detected change to index for {}: reparsing", (Object)LocalProvider.this);
                                LocalProvider.this.index = LocalProvider.this.parse(this.indexfile);
                            }
                            if (!(valid = key.reset())) break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (Collections.singletonList(watcher).get(0) != null) {
                        watcher.close();
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error("error whilst watching " + this.indexfile, (Throwable)e);
                return;
            }
        }

        @ConstructorProperties(value={"indexfile"})
        public Watcher(File indexfile) {
            this.indexfile = indexfile;
        }
    }
}

