/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.files.producers;

import java.beans.ConstructorProperties;
import java.net.URI;
import java.nio.charset.Charset;
import lombok.NonNull;
import org.virtual.files.index.AssetEntry;
import org.virtual.files.producers.AssetProducer;
import org.virtualrepository.AssetType;
import org.virtualrepository.Property;
import org.virtualrepository.comet.CometAsset;
import org.virtualrepository.csv.CsvAsset;
import org.virtualrepository.csv.CsvCodelist;
import org.virtualrepository.sdmx.SdmxCodelist;
import org.virtualrepository.spi.MutableAsset;

public class AssetProducers {
    public static AssetProducer<CsvCodelist> csvcodelistProducer = new BaseProducer<CsvCodelist>((AssetType)CsvCodelist.type){

        @Override
        public CsvCodelist transform(String id, AssetEntry entry) {
            String code = entry.properties().get("codeColumn");
            int codecol = code == null ? 0 : Integer.valueOf(code);
            CsvCodelist asset = new CsvCodelist(id, entry.name().toString(), codecol, new Property[0]);
            return (CsvCodelist)AssetProducers.configure((CsvAsset)asset, entry);
        }
    };
    public static AssetProducer<CsvAsset> csvProducer = new BaseProducer<CsvAsset>((AssetType)CsvAsset.type){

        @Override
        public CsvAsset transform(String id, AssetEntry entry) {
            CsvAsset asset = new CsvAsset(id, entry.name().toString(), new Property[0]);
            return AssetProducers.configure(asset, entry);
        }
    };
    public static AssetProducer<SdmxCodelist> sdmxCodelistProducer = new BaseProducer<SdmxCodelist>((AssetType)SdmxCodelist.type){

        @Override
        public SdmxCodelist transform(String id, AssetEntry entry) {
            SdmxCodelist asset = new SdmxCodelist(AssetProducers.get(entry, "urn"), id, AssetProducers.get(entry, "version"), entry.name().toString());
            asset.setStatus(AssetProducers.get(entry, "status"));
            asset.setURI(URI.create(AssetProducers.get(entry, "uri")));
            asset.setAgency(AssetProducers.get(entry, "agency"));
            return asset;
        }
    };
    public static AssetProducer<CometAsset> cometMappingProducer = new BaseProducer<CometAsset>((AssetType)CometAsset.type){

        @Override
        public CometAsset transform(String id, AssetEntry entry) {
            CometAsset asset = new CometAsset(id, entry.name().toString(), new Property[0]);
            return asset;
        }
    };

    private static <T extends CsvAsset> T configure(T asset, AssetEntry entry) {
        String delimiter;
        String headerFlag = entry.properties().get("hasHeader");
        boolean hasHeader = headerFlag == null ? false : Boolean.valueOf(headerFlag);
        asset.hasHeader(hasHeader);
        String encoding = entry.properties().get("encoding");
        if (encoding != null) {
            asset.setEncoding(Charset.forName(encoding));
        }
        if ((delimiter = entry.properties().get("delimiter")) != null && delimiter.length() == 1) {
            asset.setDelimiter(delimiter.charAt(0));
        }
        return asset;
    }

    private static String get(AssetEntry entry, String name) {
        return AssetProducers.get(entry, name, "unknown");
    }

    private static String get(AssetEntry entry, String name, String def) {
        String val = entry.properties().get(name);
        return val == null ? def : val;
    }

    static abstract class BaseProducer<T extends MutableAsset>
    implements AssetProducer<T> {
        @NonNull
        final AssetType type;

        @Override
        public boolean handles(AssetEntry asset) {
            return this.type.name().equals(asset.type());
        }

        @ConstructorProperties(value={"type"})
        public BaseProducer(@NonNull AssetType type) {
            if (type == null) {
                throw new IllegalArgumentException("type is null");
            }
            this.type = type;
        }
    }
}

