/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.files;

import java.util.Arrays;
import java.util.List;
import org.virtual.files.index.AssetInfo;
import org.virtual.files.producers.AssetProducer;
import org.virtual.files.producers.AssetProducers;
import org.virtualrepository.Asset;
import org.virtualrepository.Property;
import org.virtualrepository.spi.MutableAsset;

public class Assets {
    public static List<AssetProducer<?>> producers = Arrays.asList(AssetProducers.csvcodelistProducer, AssetProducers.csvProducer, AssetProducers.sdmxCodelistProducer, AssetProducers.cometMappingProducer);

    public static boolean handles(AssetInfo entry) {
        for (AssetProducer<?> $ : producers) {
            if (!$.handles(entry)) continue;
            return true;
        }
        return false;
    }

    public static MutableAsset assetFor(String id, AssetInfo entry) {
        for (AssetProducer<?> $ : producers) {
            if (!$.handles(entry)) continue;
            return Assets.asset(entry, $.transform(id, entry));
        }
        throw new IllegalArgumentException("no producers exist for asset " + entry);
    }

    public static AssetInfo updateInfoWith(AssetInfo info, Asset asset) {
        for (Property prop : asset.properties()) {
            if (!prop.is(String.class)) continue;
            info.properties().put(prop.name(), (String)prop.value(String.class));
        }
        return info;
    }

    public static AssetInfo infoFor(String path, Asset asset) {
        AssetInfo info = AssetInfo.info(asset.name(), asset.type().name(), path);
        return Assets.updateInfoWith(info, asset);
    }

    private static MutableAsset asset(AssetInfo entry, MutableAsset asset) {
        asset.properties().add(new Property[]{new Property("vfile_info", (Object)entry, false)});
        entry.properties().entrySet().stream().forEach($ -> new Property((String)$.getKey(), $.getValue()));
        return asset;
    }
}

