/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.files.local;

import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.virtual.files.Provider;
import org.virtual.files.common.Utils;
import org.virtual.files.index.AssetIndex;
import org.virtual.files.index.AssetInfo;
import org.virtual.files.local.LocalConfiguration;
import org.virtualrepository.Asset;

public class LocalProvider
implements Provider {
    private static final Logger log = LoggerFactory.getLogger(LocalProvider.class);
    private AssetIndex index;
    private LocalConfiguration configuration;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    public LocalProvider(@NonNull LocalConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is null");
        }
        this.configuration = configuration;
        this.connectTo(this.indexfile());
    }

    @Override
    public void validate(AssetInfo asset) {
        Utils.valid(this.contentfileOf(asset));
    }

    @Override
    public synchronized InputStream load(@NonNull AssetInfo asset) {
        if (asset == null) {
            throw new IllegalArgumentException("asset is null");
        }
        return new FileInputStream(this.contentfileOf(asset));
    }

    @Override
    public synchronized void update(Asset asset, AssetInfo info, InputStream contents) {
        this.store(this.contentfileOf(info), contents);
        this.store(this.indexfile());
    }

    @Override
    public synchronized void create(Asset asset, AssetInfo info, InputStream contents) {
        File file = this.contentfileOf(info);
        this.store(file, contents);
        this.index.assets().add(info);
        try {
            this.store(this.indexfile());
        }
        catch (RuntimeException e) {
            if (!file.delete()) {
                log.error("cannot delete {} after failed publication", (Object)file);
            }
            throw e;
        }
    }

    public String toString() {
        return this.configuration.name() + "@" + this.configuration.location();
    }

    private File indexfile() {
        return new File(this.configuration.location(), "vindex.json");
    }

    private File contentfileOf(AssetInfo entry) {
        return new File(this.configuration.location(), entry.path());
    }

    private void connectTo(File indexfile) {
        this.index = this.parse(indexfile);
        this.executor.execute(new Watcher(indexfile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AssetIndex parse(File indexfile) {
        AssetIndex assetIndex;
        block6: {
            FileInputStream stream = new FileInputStream(indexfile);
            try {
                assetIndex = (AssetIndex)Utils.mapper.readValue((InputStream)stream, AssetIndex.class);
                if (Collections.singletonList(stream).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (Collections.singletonList(stream).get(0) != null) {
                        stream.close();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw Utils.unchecked("cannot load index file (does it exists and contain json data?)", e);
                }
            }
            stream.close();
        }
        return assetIndex;
    }

    void store(File indexfile) {
        try {
            FileOutputStream stream = new FileOutputStream(indexfile);
            try {
                Utils.mapper.writeValue((OutputStream)stream, (Object)this.index);
            }
            finally {
                if (Collections.singletonList(stream).get(0) != null) {
                    stream.close();
                }
            }
        }
        catch (Exception e) {
            throw Utils.unchecked("cannot update index file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store(File file, InputStream stream) {
        new File(file.getAbsolutePath()).getParentFile().mkdirs();
        try {
            byte[] bytes = new byte[2048];
            FileOutputStream out = new FileOutputStream(file);
            try {
                int read = 0;
                while ((read = stream.read(bytes)) != -1) {
                    out.write(bytes, 0, read);
                }
                out.flush();
            }
            finally {
                if (Collections.singletonList(out).get(0) != null) {
                    out.close();
                }
            }
        }
        catch (Exception e) {
            throw Utils.unchecked(this + ": cannot store asset in " + file, e);
        }
    }

    @Override
    public AssetIndex index() {
        return this.index;
    }

    @Override
    public LocalConfiguration configuration() {
        return this.configuration;
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ AssetIndex access$102(LocalProvider x0, AssetIndex x1) {
        x0.index = x1;
        return x0.index;
    }

    class Watcher
    implements Runnable {
        private final File indexfile;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                while (true) lbl-1000:
                // 3 sources

                {
                    watcher = FileSystems.getDefault().newWatchService();
                    try {
                        indexpath = Paths.get(this.indexfile.getPath(), new String[0]);
                        parentpath = indexpath.getParent();
                        parentpath.register(watcher, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE});
                        block6: do {
                            key = watcher.take();
                            for (WatchEvent<?> event : key.pollEvents()) {
                                if (event.kind() == StandardWatchEventKinds.OVERFLOW || !indexpath.equals(parentpath.resolve((Path)(ev = event).context()))) continue;
                                LocalProvider.access$000().info("detected change to index for {}: reparsing", (Object)LocalProvider.this);
                                LocalProvider.access$102(LocalProvider.this, LocalProvider.this.parse(this.indexfile));
                                continue block6;
                            }
                        } while (valid = key.reset());
                        LocalProvider.access$000().error("watcher seems to be in an invalid state, trying to recreate it...");
                    }
                    finally {
                        if (Collections.singletonList(watcher).get(0) == null) continue;
                        watcher.close();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                LocalProvider.access$000().error("error whilst watching " + this.indexfile, (Throwable)e);
                return;
            }
            ** GOTO lbl-1000
        }

        @ConstructorProperties(value={"indexfile"})
        public Watcher(File indexfile) {
            this.indexfile = indexfile;
        }
    }
}

