/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.workspace;

import java.io.InputStream;
import javax.inject.Provider;
import org.gcube.common.homelibrary.home.workspace.Properties;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalFile;
import org.virtual.workspace.types.WorkspaceType;
import org.virtual.workspace.utils.Tags;
import org.virtualrepository.Asset;
import org.virtualrepository.CommonProperties;
import org.virtualrepository.Property;
import org.virtualrepository.impl.Type;
import org.virtualrepository.spi.Publisher;

public class StreamPublisher
implements Publisher<Asset, InputStream> {
    private final WorkspaceType type;
    private final Provider<Workspace> ws;

    public StreamPublisher(Provider<Workspace> ws, WorkspaceType type) {
        this.type = type;
        this.ws = ws;
    }

    public Type<? extends Asset> type() {
        return this.type.assetType();
    }

    public Class<InputStream> api() {
        return InputStream.class;
    }

    public void publish(Asset asset, InputStream content) throws Exception {
        org.virtualrepository.Properties properties = asset.properties();
        Workspace workspace = (Workspace)this.ws.get();
        String description = properties.contains(CommonProperties.DESCRIPTION.name()) ? properties.lookup(CommonProperties.DESCRIPTION.name()).value().toString() : "";
        String folderId = workspace.getRoot().getId();
        ExternalFile item = workspace.createExternalFile(asset.name(), description, this.type.mime(), content, folderId);
        Properties props = item.getProperties();
        if (asset.version() != null) {
            props.addProperty(Tags.VERSION.name(), asset.version());
        }
        for (Property prop : properties) {
            if (!prop.isDisplay()) continue;
            props.addProperty(prop.name(), prop.value().toString());
        }
        for (String tag : this.type.tags()) {
            props.addProperty(tag, "true");
        }
        this.type.toItem(asset, props);
    }
}

