/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.ows;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.virtual.ows.WfsClient;
import org.virtual.ows.profile.WfsProfile;
import org.virtual.ows.profile.WfsTypeProfile;
import org.virtualrepository.AssetType;
import org.virtualrepository.ows.WfsFeatureType;
import org.virtualrepository.spi.Browser;
import org.virtualrepository.spi.MutableAsset;

public class OwsBrowser
implements Browser {
    @NonNull
    final WfsProfile profile;
    @NonNull
    final WfsClient client;

    public Iterable<? extends MutableAsset> discover(Collection<? extends AssetType> ignore) {
        this.profile.refresh();
        return this.profile.types().stream().map(this::adapt).collect(Collectors.toList());
    }

    private WfsFeatureType adapt(WfsTypeProfile type) {
        String id = this.client.service().name() + "-" + type.name();
        return new WfsFeatureType(id, type.name(), type.properties().toArray());
    }

    @ConstructorProperties(value={"profile", "client"})
    public OwsBrowser(@NonNull WfsProfile profile, @NonNull WfsClient client) {
        if (profile == null) {
            throw new IllegalArgumentException("profile is null");
        }
        if (client == null) {
            throw new IllegalArgumentException("client is null");
        }
        this.profile = profile;
        this.client = client;
    }
}

