/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.wfs.configuration;

import dagger.Module;
import dagger.Provides;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.xml.namespace.QName;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.virtual.ows.OwsProxy;
import org.virtual.ows.OwsService;
import org.virtual.ows.WfsClient;
import org.virtual.ows.common.CommonProducers;
import org.virtual.ows.common.Utils;
import org.virtual.wfs.configuration.Configuration;
import org.virtual.wfs.configuration.ConfigurationContext;
import org.virtual.wfs.configuration.ConfigurationLocator;
import org.virtualrepository.Property;
import org.virtualrepository.RepositoryService;
import org.virtualrepository.impl.PropertyProvider;
import org.virtualrepository.spi.ServiceProxy;

@Module(includes={CommonProducers.class}, library=true)
public class ConfigurationProducers {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationProducers.class);

    @Provides
    @Singleton
    List<WfsClient> clients(@NonNull Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is null");
        }
        return configuration.services().stream().map($ -> new WfsClient((OwsService)$).mode(configuration.mode())).collect(Collectors.toList());
    }

    @Provides
    @Singleton
    List<RepositoryService> services(List<WfsClient> clients) {
        return clients.stream().map($ -> {
            QName name = $.service().name();
            String uri = $.service().uri();
            log.info("plugging geoserver {} @ {}", (Object)name, (Object)uri);
            OwsProxy proxy = new OwsProxy((WfsClient)$);
            RepositoryService service = new RepositoryService(name, (ServiceProxy)proxy, new Property[0]);
            service.properties((PropertyProvider)proxy.profile());
            return service;
        }).collect(Collectors.toList());
    }

    @Provides
    @Singleton
    Configuration configuration(ConfigurationLocator locator, ConfigurationContext ctx) {
        Logger log = LoggerFactory.getLogger(ConfigurationLocator.class);
        File location = locator.locate();
        String path = location.getAbsolutePath();
        InputStream stream = null;
        try {
            if (Utils.isValid(location)) {
                log.info("loading configuration @ {}", (Object)path);
                stream = new FileInputStream(location);
            } else {
                stream = ConfigurationLocator.class.getResourceAsStream("/ows.json");
                if (stream == null) {
                    throw new AssertionError((Object)"no configuration found on file system or classpath");
                }
                log.info("starting with classpath configuration, persisting @ {}", (Object)path);
            }
            return ctx.bind(stream);
        }
        catch (Exception e) {
            throw new RuntimeException("cannot read the configuration @ " + path, e);
        }
    }
}

