/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.ows;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import lombok.NonNull;
import org.virtual.ows.common.Utils;

public class OwsService {
    @JsonProperty
    @NonNull
    private QName name;
    @JsonProperty
    @NonNull
    private Version version = Version.v110;
    @JsonProperty
    @NonNull
    private String uri;
    @JsonProperty
    private boolean compress = true;
    @JsonProperty
    private Set<String> excludes = new HashSet<String>();
    @JsonProperty
    private boolean excludeGeom = false;

    public void uri(String uri) {
        Utils.validUri("service uri", uri);
        this.uri = uri;
    }

    @NonNull
    public QName name() {
        return this.name;
    }

    @NonNull
    public Version version() {
        return this.version;
    }

    @NonNull
    public String uri() {
        return this.uri;
    }

    public boolean compress() {
        return this.compress;
    }

    public Set<String> excludes() {
        return this.excludes;
    }

    public boolean excludeGeom() {
        return this.excludeGeom;
    }

    public OwsService name(@NonNull QName name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
        return this;
    }

    public OwsService version(@NonNull Version version) {
        if (version == null) {
            throw new IllegalArgumentException("version is null");
        }
        this.version = version;
        return this;
    }

    public OwsService compress(boolean compress) {
        this.compress = compress;
        return this;
    }

    public OwsService excludes(Set<String> excludes) {
        this.excludes = excludes;
        return this;
    }

    public OwsService excludeGeom(boolean excludeGeom) {
        this.excludeGeom = excludeGeom;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OwsService)) {
            return false;
        }
        OwsService other = (OwsService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        QName this$name = this.name();
        QName other$name = other.name();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        Version this$version = this.version();
        Version other$version = other.version();
        if (this$version == null ? other$version != null : !((Object)((Object)this$version)).equals((Object)other$version)) {
            return false;
        }
        String this$uri = this.uri();
        String other$uri = other.uri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        if (this.compress() != other.compress()) {
            return false;
        }
        Set<String> this$excludes = this.excludes();
        Set<String> other$excludes = other.excludes();
        if (this$excludes == null ? other$excludes != null : !((Object)this$excludes).equals(other$excludes)) {
            return false;
        }
        return this.excludeGeom() == other.excludeGeom();
    }

    protected boolean canEqual(Object other) {
        return other instanceof OwsService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QName $name = this.name();
        result = result * 59 + ($name == null ? 0 : ((Object)$name).hashCode());
        Version $version = this.version();
        result = result * 59 + ($version == null ? 0 : ((Object)((Object)$version)).hashCode());
        String $uri = this.uri();
        result = result * 59 + ($uri == null ? 0 : $uri.hashCode());
        result = result * 59 + (this.compress() ? 79 : 97);
        Set<String> $excludes = this.excludes();
        result = result * 59 + ($excludes == null ? 0 : ((Object)$excludes).hashCode());
        result = result * 59 + (this.excludeGeom() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "OwsService(name=" + this.name() + ", version=" + (Object)((Object)this.version()) + ", uri=" + this.uri() + ", compress=" + this.compress() + ", excludes=" + this.excludes() + ", excludeGeom=" + this.excludeGeom() + ")";
    }

    private OwsService(@NonNull QName name, @NonNull String uri) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("uri is null");
        }
        this.name = name;
        this.uri = uri;
    }

    public static OwsService service(@NonNull QName name, @NonNull String uri) {
        return new OwsService(name, uri);
    }

    public OwsService() {
    }

    public static enum Version {
        v100("1.0.0"),
        v110("1.1.0"),
        v200("2.0.0");

        private final String value;

        private Version(String value) {
            this.value = value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        public boolean before(Version v) {
            return this.ordinal() < v.ordinal();
        }
    }
}

