/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.ows.profile;

import java.beans.ConstructorProperties;
import javax.xml.namespace.QName;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.virtual.ows.WfsClient;
import org.virtual.ows.common.Utils;
import org.virtual.ows.profile.WfsProfile;
import org.virtualrepository.Properties;

abstract class WfsBaseProfile
implements WfsProfile {
    private static final Logger log = LoggerFactory.getLogger(WfsBaseProfile.class);
    @NonNull
    protected final WfsClient client;
    private Properties properties = new Properties();

    @Override
    public void refresh() {
        QName name = this.client.service().name();
        log.info("refreshing profile for {}", (Object)name);
        try {
            this.$refresh();
            if (this.properties.isEmpty()) {
                this.$update(this.properties);
                log.info("acquired properties for {} ({})", (Object)name, (Object)this.properties);
            }
        }
        catch (RuntimeException e) {
            Utils.rethrowUnchecked("cannot refresh profile for " + name, e);
        }
    }

    protected abstract void $refresh();

    protected abstract void $update(Properties var1);

    @ConstructorProperties(value={"client"})
    public WfsBaseProfile(@NonNull WfsClient client) {
        if (client == null) {
            throw new IllegalArgumentException("client is null");
        }
        this.client = client;
    }

    public Properties properties() {
        return this.properties;
    }
}

