/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.ows;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import lombok.NonNull;
import org.geotoolkit.feature.type.GeometryType;
import org.geotoolkit.feature.type.PropertyDescriptor;
import org.geotoolkit.feature.xml.jaxb.JAXBFeatureTypeReader;
import org.glassfish.jersey.client.filter.EncodingFilter;
import org.glassfish.jersey.filter.LoggingFilter;
import org.glassfish.jersey.message.GZipEncoder;
import org.opengis.feature.FeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.virtual.ows.OwsService;
import org.virtual.ows.common.Utils;
import org.virtual.wfs.configuration.Configuration;

public class WfsClient {
    private static final Logger log = LoggerFactory.getLogger(WfsClient.class);
    private final JAXBFeatureTypeReader reader = new JAXBFeatureTypeReader();
    private final Map<String, List<? extends FeatureType>> map = new HashMap<String, List<? extends FeatureType>>();
    private Configuration.Mode mode;
    @NonNull
    private final OwsService service;

    public void ping() {
        this.client(false).target(this.service.uri()).request().head();
    }

    public Invocation.Builder capabilities() {
        log.info("fetching {}'s capabilities", (Object)this.service.name());
        return this.make("GetCapabilities", false).request();
    }

    public Invocation.Builder featuresFor(@NonNull String typename) {
        if (typename == null) {
            throw new IllegalArgumentException("typename is null");
        }
        String nameClause = this.service.version().before(OwsService.Version.v200) ? "typeName" : "typeNames";
        WebTarget target = this.make("GetFeature", this.service.compress()).queryParam(nameClause, new Object[]{typename});
        if (this.service.excludeGeom() || this.service.excludes().size() > 0) {
            StringBuilder builder = new StringBuilder();
            for (String prop : this.propertiesFor(typename)) {
                builder.append(builder.length() > 0 ? "," + prop : prop);
            }
            if (builder.length() > 0) {
                target = target.queryParam("propertyName", new Object[]{builder.toString()});
            }
        }
        return target.request();
    }

    public FeatureType typeFor(@NonNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        List types = this.map.get(name);
        if (types == null) {
            try {
                String schema = (String)this.describe(name).get(String.class);
                types = this.reader.read(schema);
            }
            catch (Exception e) {
                throw Utils.unchecked("cannot acquire schemas for " + name, e);
            }
            this.map.put(name, types);
        }
        FeatureType type = (FeatureType)types.stream().filter(f -> name.contains(f.getName().toString()) || name.contains(f.getName().tip().toString())).collect(Collectors.toList()).get(0);
        return type;
    }

    private Set<String> propertiesFor(String typename) {
        HashSet<String> props = new HashSet<String>();
        org.geotoolkit.feature.type.FeatureType type = (org.geotoolkit.feature.type.FeatureType)this.typeFor(typename);
        for (PropertyDescriptor descriptor : type.getDescriptors()) {
            String ns = descriptor.getName().head().toString();
            String name = descriptor.getName().tip().toString();
            if (this.service.excludeGeom()) {
                if (descriptor.getType() instanceof GeometryType || this.service.excludes().contains(name) || name.startsWith("@") || ns.contains("gml")) continue;
                props.add(name);
                continue;
            }
            if (this.service.excludes().contains(name) || name.startsWith("@") || name.equals("name") || ns.contains("gml")) continue;
            props.add(name);
        }
        return props;
    }

    private Invocation.Builder describe(@NonNull String typename) {
        if (typename == null) {
            throw new IllegalArgumentException("typename is null");
        }
        String nameClause = this.service.version().before(OwsService.Version.v200) ? "typeName" : "typeNames";
        return this.make("DescribeFeatureType", false).queryParam(nameClause, new Object[]{typename}).request();
    }

    private WebTarget make(String $, boolean compressResponse) {
        return this.client(compressResponse).target(this.service.uri()).queryParam("service", new Object[]{"wfs"}).queryParam("version", new Object[]{this.service.version().value()}).queryParam("request", new Object[]{$});
    }

    private Client client(boolean compressResponse) {
        Client client = (Client)ClientBuilder.newClient().register((Object)ContentTypeFixer.instance);
        if (compressResponse) {
            ((Client)client.register(GZipEncoder.class)).register(EncodingFilter.class);
        }
        java.util.logging.Logger.getLogger("org.geotoolkit.feature.xml").setLevel(Level.OFF);
        if (this.mode == Configuration.Mode.development) {
            client.register((Object)new LoggingFilter(java.util.logging.Logger.getLogger(LoggingFilter.class.getName()), true));
            java.util.logging.Logger.getLogger("org.geotoolkit.feature.xml").setLevel(Level.INFO);
        }
        return client;
    }

    @ConstructorProperties(value={"service"})
    public WfsClient(@NonNull OwsService service) {
        if (service == null) {
            throw new IllegalArgumentException("service is null");
        }
        this.service = service;
    }

    public Configuration.Mode mode() {
        return this.mode;
    }

    public WfsClient mode(Configuration.Mode mode) {
        this.mode = mode;
        return this;
    }

    @NonNull
    public OwsService service() {
        return this.service;
    }

    @Priority(value=-2147483648)
    private static class ContentTypeFixer
    implements ClientResponseFilter {
        static final ContentTypeFixer instance = new ContentTypeFixer();

        private ContentTypeFixer() {
        }

        public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
            if (responseContext.getHeaderString("Content-Type").contains("subtype=gml")) {
                responseContext.getHeaders().put((Object)"Content-Type", Arrays.asList("text/xml"));
            }
        }
    }
}

