/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.ows.profile;

import java.beans.ConstructorProperties;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.geotoolkit.wfs.xml.v110.FeatureTypeType;
import org.virtual.ows.common.Utils;
import org.virtual.ows.profile.WfsTypeProfile;
import org.virtualrepository.Properties;

public class Wfs110TypeProfile
implements WfsTypeProfile {
    @NonNull
    private final FeatureTypeType type;

    @Override
    public String name() {
        return this.type.getName().getPrefix() + ":" + this.type.getName().getLocalPart();
    }

    @Override
    public Properties properties() {
        Properties properties = new Properties();
        Utils.build(properties).add("title", this.type.getTitle()).add("abstract", this.type.getAbstract()).add("keywords", this.type.getKeywords().stream().flatMap($ -> $.getKeywordList().stream()).collect(Collectors.toList()).toString()).add("default CRS", this.type.getDefaultCRS());
        return properties;
    }

    @ConstructorProperties(value={"type"})
    public Wfs110TypeProfile(@NonNull FeatureTypeType type) {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        this.type = type;
    }
}

