/*
 * Decompiled with CFR 0.152.
 */
package org.virtualrepository.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.virtualrepository.Asset;
import org.virtualrepository.AssetType;
import org.virtualrepository.RepositoryService;
import org.virtualrepository.Utils;
import org.virtualrepository.VirtualRepository;
import org.virtualrepository.impl.ServiceInspector;
import org.virtualrepository.impl.Services;
import org.virtualrepository.impl.Type;
import org.virtualrepository.spi.Importer;
import org.virtualrepository.spi.MutableAsset;
import org.virtualrepository.spi.Publisher;

public class Repository
implements VirtualRepository {
    private static final int DEFAULT_DISCOVERY_TIMEOUT = 30;
    private static final Logger log = LoggerFactory.getLogger(VirtualRepository.class);
    private final Services services;
    private Map<String, Asset> assets = new HashMap<String, Asset>();
    private ExecutorService executor = Executors.newCachedThreadPool();

    public void setExecutor(ExecutorService service) {
        this.executor = service;
    }

    public Repository() {
        this.services = new Services();
        this.services.load();
    }

    public Repository(RepositoryService ... services) {
        this(new Services(services));
    }

    public Repository(Services services) {
        Utils.notNull("services", services);
        this.services = services;
    }

    @Override
    public Services services() {
        return this.services;
    }

    @Override
    public Collection<RepositoryService> sinks(AssetType ... types) {
        ArrayList<RepositoryService> matching = new ArrayList<RepositoryService>();
        for (RepositoryService service : this.services) {
            ServiceInspector inspector = new ServiceInspector(service);
            if (inspector.taken(types).isEmpty()) continue;
            matching.add(service);
        }
        return matching;
    }

    @Override
    public Collection<RepositoryService> sources(AssetType ... types) {
        ArrayList<RepositoryService> matching = new ArrayList<RepositoryService>();
        for (RepositoryService service : this.services) {
            ServiceInspector inspector = new ServiceInspector(service);
            if (inspector.returned(types).isEmpty()) continue;
            matching.add(service);
        }
        return matching;
    }

    @Override
    public int discover(AssetType ... types) {
        return this.discover(30L, types);
    }

    @Override
    public int discover(Iterable<RepositoryService> services, AssetType ... types) {
        return this.discover(30L, services, types);
    }

    @Override
    public int discover(long timeout, AssetType ... types) {
        return this.discover(timeout, this.services, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int discover(long timeout, Iterable<RepositoryService> services, AssetType ... types) {
        Utils.notNull(types);
        List<AssetType> typeList = Arrays.asList(types);
        log.info("discovering assets of types {}", typeList);
        ExecutorCompletionService completed = new ExecutorCompletionService(this.executor);
        long time = System.currentTimeMillis();
        ArrayList<DiscoveryTask> tasks = new ArrayList<DiscoveryTask>();
        for (RepositoryService service : services) {
            ServiceInspector inspector = new ServiceInspector(service);
            List<AssetType> importTypes = inspector.returned(types);
            if (importTypes.isEmpty()) {
                log.trace("service {} does not support type(s) {} and will be ignored for discovery", (Object)service, typeList);
                continue;
            }
            DiscoveryTask task = new DiscoveryTask(service, importTypes);
            completed.submit(task, null);
            tasks.add(task);
        }
        for (int i = 0; i < tasks.size(); ++i) {
            try {
                if (completed.poll(timeout, TimeUnit.SECONDS) != null) continue;
                log.warn("asset discovery timed out after succesful interaction with {} service(s)", (Object)i);
                break;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("asset discovery was interrupted after succesful interaction with {} service(s)", (Object)i);
            }
        }
        int news = 0;
        int refreshed = 0;
        Map<String, Asset> map = this.assets;
        synchronized (map) {
            for (DiscoveryTask task : tasks) {
                for (Map.Entry<String, Asset> e : task.discovered.entrySet()) {
                    if (this.assets.put(e.getKey(), e.getValue()) == null) {
                        ++news;
                        continue;
                    }
                    ++refreshed;
                }
            }
        }
        log.info("discovered {} new asset(s) of type(s) {} (refreshed {}, total {}) in {} ms.", new Object[]{news, typeList, refreshed, this.assets.size(), System.currentTimeMillis() - time});
        return news;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Asset> iterator() {
        Map<String, Asset> map = this.assets;
        synchronized (map) {
            return new ArrayList<Asset>(this.assets.values()).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Asset lookup(String id) {
        Utils.notNull("identifier", id);
        Map<String, Asset> map = this.assets;
        synchronized (map) {
            Asset asset = this.assets.get(id);
            if (asset == null) {
                throw new IllegalStateException("unknown asset " + id);
            }
            return asset;
        }
    }

    @Override
    public List<Asset> lookup(AssetType type) {
        Utils.notNull("type", (Object)type);
        ArrayList<Asset> assets = new ArrayList<Asset>();
        for (Asset asset : this) {
            if (asset.type() != Type.any && !asset.type().equals(type)) continue;
            assets.add(asset);
        }
        return assets;
    }

    @Override
    public Map<AssetType, List<Asset>> lookup(AssetType ... types) {
        Utils.notNull(types);
        HashMap<AssetType, List<Asset>> assets = new HashMap<AssetType, List<Asset>>();
        for (AssetType type : types) {
            assets.put(type, new ArrayList());
        }
        for (Asset asset : this) {
            List assetsByType = (List)assets.get(asset.type());
            if (assetsByType == null) continue;
            assetsByType.add(asset);
        }
        return assets;
    }

    public boolean canRetrieve(Asset asset, Class<?> api) {
        if (asset.service() == null) {
            throw new IllegalArgumentException("asset " + asset.id() + " has no target service and cannot be retrieved.");
        }
        return new ServiceInspector(asset.service()).takes(asset.type(), api);
    }

    @Override
    public <A> A retrieve(final Asset asset, Class<A> api) {
        Utils.notNull(asset);
        Utils.notNull(api);
        if (asset.service() == null) {
            throw new IllegalArgumentException("asset " + asset.id() + " has no target service and cannot be retrieved");
        }
        ServiceInspector inspector = new ServiceInspector(asset.service());
        final Importer reader = inspector.importerFor(asset.type(), api);
        Callable task = new Callable<A>(){

            @Override
            public A call() throws Exception {
                return reader.retrieve(asset);
            }
        };
        try {
            log.info("retrieving data for asset {} ({})", (Object)asset.id(), (Object)asset.name());
            long time = System.currentTimeMillis();
            Future future = this.executor.submit(task);
            Object result = future.get(3L, TimeUnit.MINUTES);
            log.info("retrieved data for asset {} ({}) in {} ms.", new Object[]{asset.id(), asset.name(), System.currentTimeMillis() - time});
            return (A)result;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("timeout retrieving content for asset \n" + asset + "\n from repository service " + asset.service().name(), e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("error retrieving content for asset \n" + asset + "\n from repository service " + asset.service().name(), e.getCause());
        }
    }

    @Override
    public void publish(final Asset asset, final Object content) {
        if (asset.service() == null) {
            throw new IllegalArgumentException("asset has no target service, please set it");
        }
        ServiceInspector inspector = new ServiceInspector(asset.service());
        final Publisher writer = inspector.publisherFor(asset.type(), content.getClass());
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    writer.publish(asset, content);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        try {
            log.info("publishing asset {} to {}", (Object)asset.name(), (Object)asset.service().name());
            long time = System.currentTimeMillis();
            Future<?> future = this.executor.submit(task);
            future.get(3L, TimeUnit.MINUTES);
            log.info("published asset {} to {} in {} ms.", new Object[]{asset.name(), asset.service().name(), System.currentTimeMillis() - time});
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("timeout publishing asset \n" + asset + "\n from repository service " + asset.service().name(), e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("error publishing asset \n" + asset + "\n through repository service " + asset.service().name(), e.getCause());
        }
    }

    @Override
    public void shutdown() {
        try {
            log.info("shutting down...");
            this.executor.shutdown();
            this.executor.awaitTermination(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.warn("cannot shutdown this hub", (Throwable)e);
        }
    }

    private class DiscoveryTask
    implements Runnable {
        private final RepositoryService service;
        private final Collection<AssetType> types;
        final Map<String, Asset> discovered = new HashMap<String, Asset>();

        DiscoveryTask(RepositoryService service, Collection<AssetType> types) {
            this.service = service;
            this.types = types;
        }

        @Override
        public void run() {
            try {
                log.info("discovering assets of types {} from {}", this.types, (Object)this.service.name());
                long time = System.currentTimeMillis();
                Iterable<? extends MutableAsset> discoveredAssets = this.service.proxy().browser().discover(this.types);
                int newAssetsByThisTask = 0;
                int refreshedAssetsByThisTask = 0;
                for (MutableAsset mutableAsset : discoveredAssets) {
                    if (this.discovered.put(mutableAsset.id(), mutableAsset) == null) {
                        mutableAsset.setService(this.service);
                        ++newAssetsByThisTask;
                        continue;
                    }
                    ++refreshedAssetsByThisTask;
                }
                log.info("discovered {} asset(s) of types {} ({} new) from {} in {} ms. ", new Object[]{newAssetsByThisTask + refreshedAssetsByThisTask, this.types, newAssetsByThisTask, this.service.name(), System.currentTimeMillis() - time});
            }
            catch (Exception e) {
                log.warn("cannot discover assets from repository service " + this.service.name(), (Throwable)e);
            }
        }
    }
}

