/*
 * Decompiled with CFR 0.152.
 */
package org.virtualrepository;

import org.virtualrepository.Utils;

public class Property {
    private final String name;
    private final String description;
    private final Object value;
    private boolean display = true;

    public Property(String name, Object value) {
        this(name, value, null);
    }

    public Property(String name, Object value, boolean display) {
        this(name, value, null, display);
    }

    public Property(String name, Object value, String description) {
        this(name, value, description, true);
    }

    public Property(String name, Object value, String description, boolean display) {
        Utils.notNull("property name", name);
        Utils.notNull("property value", value);
        this.name = name;
        this.description = description;
        this.value = value;
        this.display = display;
    }

    public String name() {
        return this.name;
    }

    public void display(boolean display) {
        this.display = display;
    }

    public boolean isDisplay() {
        return this.display;
    }

    public Object value() {
        return this.value;
    }

    public <S> S value(Class<S> type) {
        if (this.is(type)) {
            return type.cast(this.value());
        }
        throw new IllegalStateException("property value " + this.value() + " of type " + this.value().getClass() + " cannot be typed as " + type.getCanonicalName());
    }

    public boolean is(Class<?> type) {
        return type.isInstance(this.value());
    }

    public String description() {
        return this.description;
    }

    public String toString() {
        return "[name=" + this.name + ", description=" + this.description + ", value=" + this.value + ", display=" + this.display + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.display ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Property other = (Property)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.display != other.display) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

