/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.sr.transforms.codelist;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.DCTerms;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.mutable.base.ItemMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.codelist.CodeMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.codelist.CodelistMutableBeanImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.virtual.sr.vocabularies.SKOS_CORE;
import org.virtualrepository.Properties;
import org.virtualrepository.sdmx.SdmxCodelist;
import org.virtualrepository.spi.Transform;

public class Rdf2SdmxCodelist
implements Transform<SdmxCodelist, Model, CodelistBean> {
    private static Logger log = LoggerFactory.getLogger(Rdf2SdmxCodelist.class);

    public CodelistBean apply(SdmxCodelist asset, Model m) throws Exception {
        log.info("transforming codelist " + asset.id() + " to sdmx");
        CodelistMutableBeanImpl codelist = new CodelistMutableBeanImpl();
        Properties props = asset.properties();
        if (props.contains("owner")) {
            codelist.setAgencyId((String)props.lookup("owner").value(String.class));
        } else {
            codelist.setAgencyId("SDMX");
        }
        codelist.setId(asset.name());
        codelist.setUri(asset.id());
        codelist.addName("en", asset.name());
        ResIterator codes = m.listSubjectsWithProperty(SKOS_CORE.notation);
        while (codes.hasNext()) {
            Resource code_resource = (Resource)codes.next();
            CodeMutableBeanImpl code = new CodeMutableBeanImpl();
            code.setId(this.adaptId(code_resource.getRequiredProperty(SKOS_CORE.notation).getLiteral().getLexicalForm()));
            code.setUri(code_resource.getURI());
            ResIterator subjectEntities = m.listSubjectsWithProperty(DCTerms.subject, (RDFNode)code_resource);
            while (subjectEntities.hasNext()) {
                Resource subjectEntity = (Resource)subjectEntities.next();
                NodeIterator labels = m.listObjectsOfProperty(subjectEntity, SKOS_CORE.prefLabel);
                while (labels.hasNext()) {
                    Literal label = labels.next().asLiteral();
                    code.addName(label.getLanguage(), label.getLexicalForm());
                }
            }
            NodeIterator definitions = m.listObjectsOfProperty(code_resource, SKOS_CORE.definition);
            while (definitions.hasNext()) {
                Literal def = definitions.next().asLiteral();
                code.addDescription(def.getLanguage(), def.getLexicalForm());
            }
            codelist.addItem((ItemMutableBean)code);
        }
        return codelist.getImmutableInstance();
    }

    public Class<Model> inputAPI() {
        return Model.class;
    }

    public Class<CodelistBean> outputAPI() {
        return CodelistBean.class;
    }

    private String adaptId(String id) {
        return id.replace(".", "_");
    }
}

