/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.sr;

import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.sparql.modify.request.QuadDataAcc;
import com.hp.hpl.jena.sparql.modify.request.UpdateDataInsert;
import com.hp.hpl.jena.update.Update;
import com.hp.hpl.jena.update.UpdateExecutionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.DCTerms;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.Calendar;
import org.apache.jena.web.DatasetGraphAccessorHTTP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.virtual.sr.RepositoryConfiguration;
import org.virtualrepository.Asset;
import org.virtualrepository.impl.Type;
import org.virtualrepository.spi.Publisher;

public class RepositoryPublisher<A extends Asset>
implements Publisher<A, Model> {
    private final RepositoryConfiguration configuration;
    private final Type<A> assetType;
    private static Logger log = LoggerFactory.getLogger(RepositoryPublisher.class);
    private final String publishEndpoint;
    private final String queryEndpoint;
    private static final Property void_sparqlEndpoint = ResourceFactory.createProperty((String)"http://rdfs.org/ns/void#sparqlEndpoint");
    private static final Property void_sparqlEndpoint_write = ResourceFactory.createProperty((String)"http://gradesystem.io/onto/void_ext.owl#sparqlEndpoint_write");
    private final DatasetGraphAccessorHTTP accessor;

    public RepositoryPublisher(Type<A> assetType, RepositoryConfiguration configuration) {
        this.assetType = assetType;
        this.configuration = configuration;
        this.publishEndpoint = configuration.staging_endpoint_update().toString();
        this.queryEndpoint = configuration.staging_endpoint_query().toString();
        this.accessor = new DatasetGraphAccessorHTTP(this.configuration.staging_endpoint_data().toString());
    }

    public Type<A> type() {
        return this.assetType;
    }

    public Class<Model> api() {
        return Model.class;
    }

    public void publish(A asset, Model rdf) throws Exception {
        log.info("Received a asset type {} with name {} ", (Object)asset.type(), (Object)asset.name());
        Statement stmt = rdf.getProperty(null, rdf.getProperty("s:r/version"));
        String assetVersion = stmt == null ? "1.0" : stmt.getString();
        String graphId = "http://gradesystem.io/staging/graph/" + assetVersion + "/" + asset.name();
        Node gNode = NodeFactory.createURI((String)graphId);
        String datasetId = "http://gradesystem.io/entity/dataset/" + asset.name();
        Node dsNode = NodeFactory.createURI((String)datasetId);
        this.addGraphMetadata((Asset)asset, rdf, gNode, dsNode);
        Model dsMetadataModel = ModelFactory.createDefaultModel();
        this.addDatasetMetadata((Asset)asset, dsMetadataModel, gNode, dsNode);
        Graph existinG = this.accessor.httpGet(gNode);
        if (existinG != null) {
            this.accessor.httpDelete(gNode);
        }
        UpdateDataInsert insertGraph = new UpdateDataInsert(this.makeQuadAcc(gNode, rdf.getGraph()));
        long time = System.currentTimeMillis();
        UpdateExecutionFactory.createRemote((Update)insertGraph, (String)this.publishEndpoint).execute();
        log.info("Staged {} triples for {} in {} ms.", new Object[]{rdf.size(), graphId, System.currentTimeMillis() - time});
        UpdateDataInsert insertDataset = new UpdateDataInsert(this.makeQuadAcc(gNode, dsMetadataModel.getGraph()));
        UpdateExecutionFactory.createRemote((Update)insertDataset, (String)this.publishEndpoint).execute();
    }

    private QuadDataAcc makeQuadAcc(Node gNode, Graph graph) {
        ExtendedIterator allTriples = graph.find(Node.ANY, Node.ANY, Node.ANY);
        QuadDataAcc qda = new QuadDataAcc();
        qda.setGraph(gNode);
        while (allTriples.hasNext()) {
            Triple triple = (Triple)allTriples.next();
            qda.addTriple(triple);
        }
        return qda;
    }

    private void addGraphMetadata(Asset asset, Model model, Node gNode, Node dsNode) {
        XSDDateTime now = new XSDDateTime(Calendar.getInstance());
        model.createResource(gNode.getURI()).addLiteral(DCTerms.created, model.createTypedLiteral((Object)now));
        model.createResource(gNode.getURI()).addProperty(DCTerms.isPartOf, dsNode.getURI());
        model.createResource(gNode.getURI()).addProperty(RDFS.label, asset.name());
        model.createResource(gNode.getURI()).addProperty(DCTerms.creator, (RDFNode)model.createResource("http://virtualrepository/plugin/sr"));
    }

    private void addDatasetMetadata(Asset asset, Model model, Node gNode, Node dsNode) {
        XSDDateTime now = new XSDDateTime(Calendar.getInstance());
        model.createResource(dsNode.getURI()).addLiteral(DCTerms.modified, model.createTypedLiteral((Object)now));
        model.createResource(dsNode.getURI()).addProperty(DCTerms.hasPart, gNode.getURI());
        model.createResource(dsNode.getURI()).addProperty(RDF.type, (RDFNode)model.createResource("http://rdfs.org/ns/void#Dataset"));
        model.createResource(dsNode.getURI()).addProperty(void_sparqlEndpoint, (RDFNode)model.createResource(this.queryEndpoint));
        model.createResource(dsNode.getURI()).addProperty(void_sparqlEndpoint_write, (RDFNode)model.createResource(this.publishEndpoint));
        model.createResource(dsNode.getURI()).addProperty(RDFS.label, asset.name());
    }
}

