/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.sr.transforms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import javax.xml.namespace.QName;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotationBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodeBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.virtualrepository.sdmx.SdmxCodelist;
import org.virtualrepository.spi.Transform;
import org.virtualrepository.tabular.Column;
import org.virtualrepository.tabular.DefaultTable;
import org.virtualrepository.tabular.Row;
import org.virtualrepository.tabular.Table;

public class Sdmx2Table
implements Transform<SdmxCodelist, CodelistBean, Table> {
    public Table apply(SdmxCodelist asset, CodelistBean codelist) throws Exception {
        LinkedHashSet<Column> columns = new LinkedHashSet<Column>();
        Column codeColumn = new Column(new QName(asset.name() + "-code"), new QName("code"), String.class);
        if (!codelist.getItems().isEmpty()) {
            columns.add(codeColumn);
        }
        ArrayList<Row> rows = new ArrayList<Row>();
        for (CodeBean code : codelist.getItems()) {
            Column column;
            QName columnName;
            HashMap<QName, String> data = new HashMap<QName, String>();
            data.put(codeColumn.name(), code.getId());
            for (TextTypeWrapper name : code.getNames()) {
                columnName = new QName("name-" + name.getLocale());
                column = new Column(columnName, new QName("name"), String.class);
                columns.add(column);
                data.put(columnName, name.getValue());
            }
            for (TextTypeWrapper description : code.getDescriptions()) {
                columnName = new QName("description-" + description.getLocale());
                column = new Column(columnName, new QName("description"), String.class);
                columns.add(column);
                data.put(columnName, description.getValue());
            }
            for (AnnotationBean annotation : code.getAnnotations()) {
                for (TextTypeWrapper text : annotation.getText()) {
                    String title = annotation.getTitle() == null ? (annotation.getType() == null ? "annotation" : annotation.getType()) : annotation.getTitle();
                    QName columnName2 = new QName(title + "-" + text.getLocale());
                    QName type = annotation.getType() == null ? new QName("annotation") : new QName(annotation.getType());
                    Column column2 = new Column(columnName2, type, String.class);
                    columns.add(column2);
                    data.put(columnName2, text.getValue());
                }
            }
            Row row = new Row(data);
            rows.add(row);
        }
        return new DefaultTable(new ArrayList(columns), rows);
    }

    public Class<CodelistBean> inputAPI() {
        return CodelistBean.class;
    }

    public Class<Table> outputAPI() {
        return Table.class;
    }
}

