package org.gcube.common.calls.jaxrs;

import javax.xml.namespace.QName;

/**
 * The clauses of a simple DSL to build {@link GcubeService}.
 * 
 * @author Fabio Simeoni
 *
 */
public interface GcubeServiceBuilderDSL {

	/**
	 * The clause that sets the name of the target service. 
	 * 
	 * @author Fabio Simeoni
	 *
	 */
	static interface NameClause {
		
		/**
		 * Sets the qualified name of the target service.
		 * 
		 * @param name the qualified name of the target service
		 * @return the next clause
		 */
		StubClause withName(QName name);
		
	}
	
	/**
	 * The clause that sets the stub interface of the target service. 
	 * 
	 * @author Fabio Simeoni
	 *
	 */
	static interface StubClause {
		
		/**
		 * Uses the root path for the service.
		 * @return the {@link GcubeService} that describes the target service.
		 */
		GcubeService useRootPath();

		/**
		 * Sets the service path.
		 * @param path the service path
		 * @return the {@link GcubeService} that describes the target service.
		 */
		GcubeService andPath(String path);
	}
}
