package org.gcube.common.calls.jaxrs;

import java.io.IOException;
import java.util.Collections;
import java.util.Map.Entry;

import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;

import org.gcube.common.calls.Interceptors;
import org.gcube.common.calls.Request;
import org.gcube.common.security.providers.SecretManagerProvider;

/**
 * JAX-RS client request filter for gCube services.
 * Handles request processing and security context management.
 * 
 * @author Fabio Simeoni
 */
public class JaxRSRequestFilter implements ClientRequestFilter {

	private GcubeService service;

	/**
	 * Creates a new JAX-RS request filter for the given service.
	 * 
	 * @param service the gCube service
	 */
	public JaxRSRequestFilter(GcubeService service) {
		super();
		this.service = service;
	}

	@Override
	public void filter(final ClientRequestContext rc) throws IOException {
		if (SecretManagerProvider.get()!=null){
			Request requestContext = Interceptors.executeRequestChain(service.call());
			for (Entry<String, String> entry: requestContext.getHeaders()){
				rc.getHeaders().put(entry.getKey(), Collections.singletonList((Object)entry.getValue()));	
			}
		}
	}
}
