/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.keycloak.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.com.fasterxml.jackson.annotation.JsonInclude;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.core.type.TypeReference;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.ObjectWriter;
import org.gcube.common.keycloak.model.AccessToken;
import org.gcube.common.keycloak.model.RefreshToken;
import org.gcube.common.keycloak.model.TokenResponse;
import org.gcube.io.jsonwebtoken.ExpiredJwtException;
import org.gcube.io.jsonwebtoken.JwtException;
import org.gcube.io.jsonwebtoken.Jwts;
import org.gcube.io.jsonwebtoken.io.DeserializationException;
import org.gcube.io.jsonwebtoken.io.Deserializer;
import org.gcube.io.jsonwebtoken.security.SignatureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelUtils {
    protected static final Logger logger = LoggerFactory.getLogger(ModelUtils.class);
    private static final String ACCOUNT_AUDIENCE_RESOURCE = "account";
    private static final ObjectMapper mapper = new ObjectMapper();

    public static String toJSONString(Object object) {
        return ModelUtils.toJSONString(object, false);
    }

    public static String toJSONString(Object object, boolean prettyPrint) {
        ObjectWriter writer = prettyPrint ? mapper.writerWithDefaultPrettyPrinter() : mapper.writer();
        try {
            return writer.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            logger.error("Cannot pretty print object", (Throwable)e);
            return null;
        }
    }

    public static RSAPublicKey createRSAPublicKey(String publicKeyPem) throws Exception {
        return (RSAPublicKey)ModelUtils.createPublicKey(publicKeyPem, "RSA");
    }

    public static PublicKey createPublicKey(String publicKeyPem, String algorithm) throws Exception {
        try {
            String publicKey = publicKeyPem.replaceFirst("-----BEGIN (.*)-----\n", "");
            publicKey = publicKey.replaceFirst("-----END (.*)-----", "");
            publicKey = publicKey.replaceAll("\r\n", "");
            publicKey = publicKey.replaceAll("\n", "");
            byte[] encoded = Base64.getDecoder().decode(publicKey);
            KeyFactory kf = KeyFactory.getInstance(algorithm);
            return kf.generatePublic(new X509EncodedKeySpec(encoded));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create public key from PEM string", e);
        }
    }

    public static boolean isValid(String token, PublicKey publicKey) throws Exception {
        return ModelUtils.isValid(token, publicKey, true);
    }

    public static boolean isValid(String token, PublicKey publicKey, boolean checkExpiration) throws Exception {
        try {
            ModelUtils.verify(token, publicKey);
            return true;
        }
        catch (ExpiredJwtException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("JWT is expired: {}", (Object)e.getMessage());
            }
            return !checkExpiration;
        }
        catch (SignatureException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("JWT signature is not verified: {}", (Object)e.getMessage());
            }
            return false;
        }
        catch (JwtException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("JWT object is not valid: {}", (Object)e.getMessage());
            }
            return false;
        }
    }

    public static void verify(String token, PublicKey publicKey) throws SignatureException, ExpiredJwtException, JwtException, Exception {
        Jwts.parser().json((Deserializer)new GcubeJacksonDeserializer()).verifyWith(publicKey).build().parse((CharSequence)token);
    }

    public static String getAccessTokenPayloadJSONStringFrom(TokenResponse tokenResponse) throws Exception {
        return ModelUtils.getAccessTokenPayloadJSONStringFrom(tokenResponse, true);
    }

    public static String getAccessTokenPayloadJSONStringFrom(TokenResponse tokenResponse, boolean prettyPrint) throws Exception {
        return ModelUtils.toJSONString(ModelUtils.getAccessTokenFrom(tokenResponse, Object.class), prettyPrint);
    }

    public static AccessToken getAccessTokenFrom(TokenResponse tokenResponse) throws Exception {
        return ModelUtils.getAccessTokenFrom(tokenResponse, AccessToken.class);
    }

    public static AccessToken getAccessTokenFrom(String authorizationHeaderOrBase64EncodedJWT) throws Exception {
        return ModelUtils.getAccessTokenFrom(authorizationHeaderOrBase64EncodedJWT.matches("[b|B]earer ") ? authorizationHeaderOrBase64EncodedJWT.substring("bearer ".length()) : authorizationHeaderOrBase64EncodedJWT, AccessToken.class);
    }

    private static <T> T getAccessTokenFrom(TokenResponse tokenResponse, Class<T> clazz) throws Exception {
        return ModelUtils.getAccessTokenFrom(tokenResponse.getAccessToken(), clazz);
    }

    private static <T> T getAccessTokenFrom(String accessToken, Class<T> clazz) throws Exception {
        return (T)mapper.readValue(ModelUtils.getDecodedPayload(accessToken), clazz);
    }

    public static String getRefreshTokenPayloadStringFrom(TokenResponse tokenResponse) throws Exception {
        return ModelUtils.getRefreshTokenPayloadStringFrom(tokenResponse, true);
    }

    public static String getRefreshTokenPayloadStringFrom(TokenResponse tokenResponse, boolean prettyPrint) throws Exception {
        return ModelUtils.toJSONString(ModelUtils.getRefreshTokenFrom(tokenResponse, Object.class), prettyPrint);
    }

    public static RefreshToken getRefreshTokenFrom(TokenResponse tokenResponse) throws Exception {
        return ModelUtils.getRefreshTokenFrom(tokenResponse.getRefreshToken());
    }

    public static RefreshToken getRefreshTokenFrom(String base64EncodedJWT) throws Exception {
        return (RefreshToken)mapper.readValue(ModelUtils.getDecodedPayload(base64EncodedJWT), RefreshToken.class);
    }

    private static <T> T getRefreshTokenFrom(TokenResponse tokenResponse, Class<T> clazz) throws Exception {
        return (T)mapper.readValue(ModelUtils.getDecodedPayload(tokenResponse.getRefreshToken()), clazz);
    }

    protected static byte[] getBase64Decoded(String string) {
        return Base64.getDecoder().decode(string);
    }

    protected static String splitAndGet(String encodedJWT, int index) {
        String[] split = encodedJWT.split("\\.");
        if (split.length == 3) {
            return split[index];
        }
        return null;
    }

    public static byte[] getDecodedHeader(String value) {
        return ModelUtils.getBase64Decoded(ModelUtils.getEncodedHeader(value));
    }

    public static String getEncodedHeader(String encodedJWT) {
        return ModelUtils.splitAndGet(encodedJWT, 0);
    }

    public static byte[] getDecodedPayload(String value) {
        return ModelUtils.getBase64Decoded(ModelUtils.getEncodedPayload(value));
    }

    public static String getEncodedPayload(String encodedJWT) {
        return ModelUtils.splitAndGet(encodedJWT, 1);
    }

    public static byte[] getDecodedSignature(String value) {
        return ModelUtils.getBase64Decoded(ModelUtils.getEncodedSignature(value));
    }

    public static String getEncodedSignature(String encodedJWT) {
        return ModelUtils.splitAndGet(encodedJWT, 2);
    }

    public static String getClientIdFromToken(AccessToken accessToken) {
        logger.debug("Client id not provided, using authorized party field (azp)");
        String clientId = accessToken.getIssuedFor();
        if (clientId == null) {
            logger.warn("Issued for field (azp) not present, getting first of the audience field (aud)");
            clientId = ModelUtils.getFirstAudienceNoAccount(accessToken);
        }
        return clientId;
    }

    private static String getFirstAudienceNoAccount(AccessToken accessToken) {
        List<String> tokenAud = Arrays.asList(accessToken.getAudience());
        tokenAud.remove(ACCOUNT_AUDIENCE_RESOURCE);
        if (tokenAud.size() > 0) {
            return tokenAud.iterator().next();
        }
        return "";
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public static class GcubeJacksonDeserializer
    implements Deserializer<Map<String, ?>> {
        public Map<String, ?> deserialize(byte[] bytes) throws DeserializationException {
            return this.deserialize(new InputStreamReader(new ByteArrayInputStream(bytes)));
        }

        public Map<String, ?> deserialize(Reader reader) throws DeserializationException {
            try {
                return (Map)new ObjectMapper().readValue(reader, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
            }
            catch (IOException e) {
                throw new DeserializationException("Cannot deserialize JSON with GCube Jackson", (Throwable)e);
            }
        }
    }
}

