This project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

# Changelog for "keycloak-client"

## [v3.0.0-SNAPSHOT]

- Moved to jdk17
- Moved to smartgear 4
- maven-parent-javax 1.4.0-SNAPSHOT
- java 21 for javax version

## [v2.2.0]
- Added support to add scopes in requests in client and constants for d4s-context dynamic scope. [#28084]
- Added tests to demonstrate dynamic scopes for clients and for users on both private and public clients [#28084]
- Moved form gxJRS to low level gxHTTP [#28294]
- Moved to `jjwt` internal lib [#28296]

## [v2.1.0] - 2024-05-07
- Added `token-exchange` support, also with `offline-token` scope, and methods to add extra headers during the OIDC token requests [#27099].
- Added custom base URL set via factory (not automatically working cross environments) [#27234]
- Added JWKS server configuration retrieval, realm's info (as `PublishedRealmRepresentation` JSON containing public key) and JWT digital signature verification by using the RSA public key of the realm on server. It uses the `jjwt` library by `io.jsonwebtoken` [#27340]

## [v2.0.0] - 2023-07-21
- Removed the discovery functionality to be compatible with SmartGears.v4 and moved to the new library `keycloak-client-legacy-is` that will provide the backward compatibility. [#23478].
- Fixed typo in `AccessToken` class for `setAccessToken(..)` method [#23654]
- Added predictive infrastructure URL support based on context (and on context and realm if the target realm is not the default one) and overloaded all methods that take the URL as argument with the context. [#23655]
- Added support for the use of the custom Keycloak's D4S mapper that maps/shrink the `aud` (and optionally also the resource access) to the value requested via `X-D4Science-Context` HTTP header.
- Added support of password grant flow (corresponding to the now deprecated OAuth2 flow: Resource Owner Password Credentials grant) also for specific context/audience by using the specific D4S mapper. [#25291]
- Added new `KeycloakClientHelper` class to perform token request for user in one shot and without the need to provide the `clientId` parameter. Only `context`, `username` and `password` are required. [#25291][#25291]
- Added functions to introspect and verify access tokens (both OIDC and UMA are supported) [#23326]

## [v1.2.0] - 2022-04-04
- Added OIDC token retrieve for clients and UMA token from OIDC token as bearer auth, instead of credentials only (basic auth)[#23076]

## [v1.1.0] - 2022-01-13
- Added refresh token facilities for expired tokens and some helper methods added [#22515]

## [v1.0.1] - 2021-10-07
- First release, provides the basic helper classes for Keycloak tokens retrieve and functions for the gCube framework integration (automatic service discovery) [#21389] [#22155]
