/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.lang;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.gcube.io.jsonwebtoken.impl.lang.Converter;
import org.gcube.io.jsonwebtoken.lang.DateFormats;

public class JwtDateConverter
implements Converter<Date, Object> {
    public static final JwtDateConverter INSTANCE = new JwtDateConverter();

    @Override
    public Object applyTo(Date date) {
        if (date == null) {
            return null;
        }
        return date.getTime() / 1000L;
    }

    @Override
    public Date applyFrom(Object o) {
        return JwtDateConverter.toSpecDate(o);
    }

    public static Date toSpecDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            try {
                value = Long.parseLong((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (value instanceof Number) {
            long seconds = ((Number)value).longValue();
            value = seconds * 1000L;
        }
        return JwtDateConverter.toDate(value);
    }

    public static Date toDate(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof Date) {
            return (Date)v;
        }
        if (v instanceof Calendar) {
            return ((Calendar)v).getTime();
        }
        if (v instanceof Number) {
            long millis = ((Number)v).longValue();
            return new Date(millis);
        }
        if (v instanceof String) {
            return JwtDateConverter.parseIso8601Date((String)v);
        }
        String msg = "Cannot create Date from object of type " + v.getClass().getName() + ".";
        throw new IllegalArgumentException(msg);
    }

    private static Date parseIso8601Date(String value) throws IllegalArgumentException {
        try {
            return DateFormats.parseIso8601Date((String)value);
        }
        catch (ParseException e) {
            String msg = "String value is not a JWT NumericDate, nor is it ISO-8601-formatted. All heuristics exhausted. Cause: " + e.getMessage();
            throw new IllegalArgumentException(msg, e);
        }
    }
}

