/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.publisher.is.legacy.container;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxDistributionInfo {
    private static final Logger logger = LoggerFactory.getLogger(LinuxDistributionInfo.class);
    public static final String LSB_RELEASE_COMMAND = "lsb_release -a";
    public static final String OS_RELEASE_FILE_PATH = "/etc/os-release";
    protected Map<String, String> info;

    protected Map<String, String> getInfoViaLsbReleaseCommand() throws IOException {
        logger.trace("Going to exec {}", (Object)LSB_RELEASE_COMMAND);
        Process process = Runtime.getRuntime().exec(LSB_RELEASE_COMMAND);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        Map<String, String> map = this.parseBufferedReader(bufferedReader);
        bufferedReader.close();
        return map;
    }

    private Map<String, String> parseBufferedReader(BufferedReader bufferedReader) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        String line = "";
        while ((line = bufferedReader.readLine()) != null) {
            String[] nameValue = this.parseLine(line);
            map.put(nameValue[0], nameValue[1]);
        }
        return map;
    }

    private String[] parseLine(String line) {
        String[] splitted = line.split("=");
        if (splitted.length < 2) {
            splitted = line.split(":");
        }
        String[] ret = new String[]{splitted[0].trim(), splitted[1].trim().replace("\"", "")};
        return ret;
    }

    private Map<String, String> getInfoViaFile(File file) throws IOException {
        logger.trace("Going to read file {}", (Object)file.getAbsolutePath());
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        Map<String, String> map = this.parseBufferedReader(bufferedReader);
        bufferedReader.close();
        return map;
    }

    protected Map<String, String> getInfoViaOsReleaseFile() throws IOException {
        File osReleaseFile = new File(OS_RELEASE_FILE_PATH);
        return this.getInfoViaFile(osReleaseFile);
    }

    private Map<String, String> retriveInfo() {
        try {
            return this.getInfoViaLsbReleaseCommand();
        }
        catch (IOException iOException) {
            try {
                return this.getInfoViaOsReleaseFile();
            }
            catch (IOException iOException2) {
                return null;
            }
        }
    }

    public Map<String, String> getInfo() {
        if (this.info == null) {
            this.info = this.retriveInfo();
        }
        return this.info;
    }
}

