/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.types;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.com.fasterxml.jackson.databind.DeserializationFeature;
import org.gcube.com.fasterxml.jackson.databind.JavaType;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.type.CollectionType;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.types.annotations.Deserialize;
import org.gcube.informationsystem.types.impl.TypeImpl;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.Changelog;
import org.gcube.informationsystem.types.reference.Type;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.informationsystem.types.reference.entities.EntityType;
import org.gcube.informationsystem.types.reference.entities.FacetType;
import org.gcube.informationsystem.types.reference.entities.ResourceType;
import org.gcube.informationsystem.types.reference.properties.LinkedEntity;
import org.gcube.informationsystem.types.reference.properties.PropertyDefinition;
import org.gcube.informationsystem.types.reference.properties.PropertyType;
import org.gcube.informationsystem.types.reference.relations.ConsistsOfType;
import org.gcube.informationsystem.types.reference.relations.IsRelatedToType;
import org.gcube.informationsystem.types.reference.relations.RelationType;
import org.gcube.informationsystem.utils.Version;

public class TypeMapper {
    protected static final ObjectMapper mapper = new ObjectMapper();

    public static String serializeTypeDefinition(Type type) throws Exception {
        String json = mapper.writeValueAsString((Object)type);
        return json;
    }

    public static Type deserializeTypeDefinition(String json) throws Exception {
        Type type = (Type)mapper.readValue(json, Type.class);
        return type;
    }

    public static String serializeTypeDefinitions(List<Type> typeDefinitions) throws Exception {
        CollectionType javaType = mapper.getTypeFactory().constructCollectionType(List.class, Type.class);
        return mapper.writerFor((JavaType)javaType).writeValueAsString(typeDefinitions);
    }

    public static List<Type> deserializeTypeDefinitions(String json) throws Exception {
        CollectionType javaType = mapper.getTypeFactory().constructCollectionType(ArrayList.class, Type.class);
        return (List)mapper.readValue(json, (JavaType)javaType);
    }

    public static <E extends Element> Type createTypeDefinition(Class<E> clz) {
        Type type = TypeImpl.getInstance(clz);
        return type;
    }

    public static <E extends Element> String serializeType(Class<E> clz) throws Exception {
        Type type = TypeMapper.createTypeDefinition(clz);
        return TypeMapper.serializeTypeDefinition(type);
    }

    public static <E extends Element> String getType(E e) {
        return TypeMapper.getType(e.getClass());
    }

    public static <E extends Element, EImpl extends E> Class<EImpl> getDynamicImplementation(Class<E> clz) {
        Deserialize deserialize;
        Class<?> annotatedClass;
        if (clz.isInterface() && clz.isAnnotationPresent(Deserialize.class) && clz.isAssignableFrom(annotatedClass = (deserialize = clz.getAnnotation(Deserialize.class)).as()) && !annotatedClass.isInterface()) {
            Class<?> implementationClz = annotatedClass;
            return implementationClz;
        }
        return null;
    }

    public static String getType(Class<? extends Element> clz) {
        String classSimpleName = clz.getSimpleName();
        String name = null;
        if (!clz.isInterface() && clz.isAnnotationPresent(JsonTypeName.class)) {
            JsonTypeName jsonTypeName = clz.getAnnotation(JsonTypeName.class);
            name = jsonTypeName.value();
            if (name == null || name.compareTo("") == 0) {
                throw new RuntimeException("Invalid annotation @JsonTypeName for type " + classSimpleName);
            }
            return name;
        }
        if (clz.isAnnotationPresent(TypeMetadata.class)) {
            TypeMetadata typeMetadata = clz.getAnnotation(TypeMetadata.class);
            String typeMetadataName = typeMetadata.name();
            if (typeMetadataName != null && typeMetadataName.compareTo("") != 0) {
                return typeMetadataName;
            }
            throw new RuntimeException("Invalid Name in annotation @TypeMetadata for type " + classSimpleName);
        }
        throw new RuntimeException("You must provide @TypeMetadata for " + classSimpleName);
    }

    public static String getTypeDescription(Class<? extends Element> clz) {
        String classSimpleName = clz.getSimpleName();
        if (clz.isAnnotationPresent(TypeMetadata.class)) {
            TypeMetadata typeMetadata = clz.getAnnotation(TypeMetadata.class);
            String description = typeMetadata.description();
            if (description != null && description.compareTo("") != 0) {
                return description;
            }
            throw new RuntimeException("Invalid Description in annotation @TypeMetadata for type " + classSimpleName);
        }
        throw new RuntimeException("You must provide @TypeMetadata for " + classSimpleName);
    }

    public static Version getTypeVersion(Class<? extends Element> clz) {
        String classSimpleName = clz.getSimpleName();
        if (clz.isAnnotationPresent(TypeMetadata.class)) {
            TypeMetadata typeMetadata = clz.getAnnotation(TypeMetadata.class);
            return new Version(typeMetadata.version());
        }
        throw new RuntimeException("You must provide @TypeMetadata for " + classSimpleName);
    }

    public static Map<Version, String> getTypeChangelog(Class<? extends Element> clz) {
        Version typeVersion;
        HashMap<Version, String> map = new HashMap<Version, String>();
        if (clz.isAnnotationPresent(Changelog.class)) {
            Change[] changes;
            Changelog changelog = clz.getAnnotation(Changelog.class);
            for (Change change : changes = changelog.value()) {
                String version = change.version();
                Version typeVersion2 = new Version(version);
                if (map.containsKey(typeVersion2)) {
                    throw new RuntimeException("Duplicated version " + version + " in @Change annotation");
                }
                String description = change.description();
                if (description == null || description.compareTo("") == 0) {
                    throw new RuntimeException("A valid description for version " + version + " must be provided in @Change annotation");
                }
                map.put(typeVersion2, description);
            }
        }
        if (!map.containsKey(Version.MINIMAL_VERSION)) {
            map.putAll(TypeImpl.DEFAULT_CHANGELOG_MAP);
        }
        if (!map.containsKey(typeVersion = TypeMapper.getTypeVersion(clz))) {
            throw new RuntimeException("The Type " + clz.getSimpleName() + " does not provided the appropriated changelog Map");
        }
        ArrayList versions = new ArrayList(map.keySet());
        versions.sort(new Comparator<Version>(){

            @Override
            public int compare(Version o1, Version o2) {
                return o2.compareTo(o1);
            }
        });
        if (((Version)versions.get(0)).compareTo(typeVersion) != 0) {
            throw new RuntimeException("The Type declared version (i.e." + typeVersion.toString() + ") does not match the highest version declared in changelog (i.e. " + String.valueOf(versions.get(0)) + "). Please fix your type.");
        }
        return map;
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES, false);
        mapper.registerSubtypes(new Class[]{Type.class});
        mapper.registerSubtypes(new Class[]{EntityType.class});
        mapper.registerSubtypes(new Class[]{ResourceType.class});
        mapper.registerSubtypes(new Class[]{FacetType.class});
        mapper.registerSubtypes(new Class[]{RelationType.class});
        mapper.registerSubtypes(new Class[]{IsRelatedToType.class});
        mapper.registerSubtypes(new Class[]{ConsistsOfType.class});
        mapper.registerSubtypes(new Class[]{PropertyType.class});
        mapper.registerSubtypes(new Class[]{PropertyDefinition.class});
        mapper.registerSubtypes(new Class[]{LinkedEntity.class});
    }
}

