/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorization.library.provider;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ServiceIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String serviceClass;
    private String serviceName;
    private String serviceId;

    protected ServiceIdentifier() {
    }

    public ServiceIdentifier(String serviceClass, String serviceName, String serviceId) {
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.serviceId = serviceId;
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getFullIdentifier() {
        return this.serviceClass + ":" + this.serviceName + ":" + this.serviceId;
    }

    public static ServiceIdentifier getServiceIdentifierFromId(String serviceId) {
        String[] split = serviceId.split(":");
        if (split.length != 3) {
            throw new IllegalArgumentException("invalid serviceId provided: " + serviceId);
        }
        return new ServiceIdentifier(split[0], split[1], split[2]);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.serviceClass == null ? 0 : this.serviceClass.hashCode());
        result = 31 * result + (this.serviceId == null ? 0 : this.serviceId.hashCode());
        result = 31 * result + (this.serviceName == null ? 0 : this.serviceName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceIdentifier other = (ServiceIdentifier)obj;
        if (this.serviceClass == null ? other.serviceClass != null : !this.serviceClass.equals(other.serviceClass)) {
            return false;
        }
        if (this.serviceId == null ? other.serviceId != null : !this.serviceId.equals(other.serviceId)) {
            return false;
        }
        return !(this.serviceName == null ? other.serviceName != null : !this.serviceName.equals(other.serviceName));
    }
}

