package org.gcube.informationsystem.resourceregistry.api.exceptions;

import java.io.Serial;

/**
 * The Class NotFoundException.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public class NotFoundException extends ResourceRegistryException {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = -1687373446724146351L;

	/**
	 * Instantiates a new not found exception.
	 *
	 * @param message the message
	 */
	public NotFoundException(String message) {
		super(message);
	}

	/**
	 * Instantiates a new not found exception.
	 *
	 * @param cause the cause
	 */
	public NotFoundException(Throwable cause) {
		super(cause);
	}
	
	/**
	 * Instantiates a new not found exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public NotFoundException(String message, Throwable cause) {
		super(message, cause);
	}
}
