/**
 * 
 */
package org.gcube.informationsystem.resourceregistry.api.exceptions;

import java.io.Serial;


import org.gcube.com.fasterxml.jackson.annotation.JsonTypeInfo;

/**
 * The Class ResourceRegistryException.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME)
public class ResourceRegistryException extends Exception {

	/**
	 *  Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = -8321258637131836003L;
	
	/**
	 * Instantiates a new resource registry exception.
	 *
	 * @param message the message
	 */
	public ResourceRegistryException(String message) {
		super(message);
	}
	
	/**
	 * Instantiates a new resource registry exception.
	 *
	 * @param cause the cause
	 */
	public ResourceRegistryException(Throwable cause) {
		super(cause);
	}
	
	/**
	 * Instantiates a new resource registry exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public ResourceRegistryException(String message, Throwable cause) {
		super(message, cause);
	}
	
}
