package org.gcube.informationsystem.resourceregistry.api.request;

import org.gcube.informationsystem.base.reference.IdentifiableElement;
import org.gcube.informationsystem.model.reference.properties.Metadata;

/**
 * The Class BaseRequestInfo.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public class BaseRequestInfo implements RequestInfo {
	
	/**
	 * The offset parameter indicates the starting position of the result.
	 */
	protected Integer offset;
	
	/**
	 *  To get unlimited results the limit query parameters must be set to -1.
	 * 	If the results are too much the operation could have a timeout.
	 */
	protected Integer limit;
	
	/**
	 * Track if the request requested to include {@link Metadata}
	 */
	protected boolean includeMeta;
	
	/**
	 * Track if the request requested to include {@link Metadata} in all
	 * {@link IdentifiableElement} or just in the root instance
	 */
	protected boolean allMeta;
	
	
	/**
	 * Track if hierarchicalMode has been requested
	 */
	protected boolean hierarchicalMode;
	
	/**
	 * Track if the request requested to include contexts
	 */
	protected boolean includeContexts;
	
	/**
	 * Instantiates a new base request info.
	 */
	public BaseRequestInfo() {
		this(null, null);
	}
	
	/**
	 * Instantiates a new base request info.
	 *
	 * @param offset the offset
	 * @param limit the limit
	 */
	public BaseRequestInfo(Integer offset, Integer limit) {
		this.offset = offset;
		this.limit = limit;
		this.includeMeta = false;
		this.allMeta = false;
		this.hierarchicalMode = false;
		this.includeContexts = false;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public Integer getLimit() {
		return limit;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setLimit(Integer limit) {
		this.limit = limit;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Integer getOffset() {
		return offset;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setOffset(Integer offset) {
		this.offset = offset;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean includeMeta() {
		return includeMeta;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setIncludeMeta(boolean includeMeta) {
		this.includeMeta = includeMeta;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean allMeta() {
		return allMeta;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setAllMeta(boolean allMeta) {
		this.allMeta = allMeta;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isHierarchicalMode() {
		return hierarchicalMode;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setHierarchicalMode(boolean hierarchicalMode) {
		this.hierarchicalMode = hierarchicalMode;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean includeContexts() {
		return includeContexts;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setIncludeContexts(boolean includeContexts) {
		this.includeContexts = includeContexts;
	}

}
