package org.gcube.informationsystem.resourceregistry.api.exceptions.entities;

import java.io.Serial;


import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;

/**
 * The Class EntityNotFoundException.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public class EntityNotFoundException extends NotFoundException {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = -1687373446724146351L;

	/**
	 * Instantiates a new entity not found exception.
	 *
	 * @param message the message
	 */
	public EntityNotFoundException(String message) {
		super(message);
	}

	/**
	 * Instantiates a new entity not found exception.
	 *
	 * @param cause the cause
	 */
	public EntityNotFoundException(Throwable cause) {
		super(cause);
	}

	/**
	 * Instantiates a new entity not found exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public EntityNotFoundException(String message, Throwable cause) {
		super(message, cause);
	}
}
