package org.gcube.informationsystem.resourceregistry.api.exceptions.entities.resource;

import java.io.Serial;


import org.gcube.informationsystem.resourceregistry.api.exceptions.entities.EntityNotFoundException;

/**
 * The Class ResourceNotFoundException.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public class ResourceNotFoundException extends EntityNotFoundException {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = 8635077520624797114L;

	/**
	 * Instantiates a new resource not found exception.
	 *
	 * @param message the message
	 */
	public ResourceNotFoundException(String message) {
		super(message);
	}

	/**
	 * Instantiates a new resource not found exception.
	 *
	 * @param cause the cause
	 */
	public ResourceNotFoundException(Throwable cause) {
		super(cause);
	}
	
	/**
	 * Instantiates a new resource not found exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public ResourceNotFoundException(String message, Throwable cause) {
		super(message, cause);
	}

}
